/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import com.ibm.icu.util.ULocale;
import java.text.MessageFormat;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.computations.Polygon;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.ScaleUnitType;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.PluginSettings;

public class ChartUtil {
    private static final double EPS = 1.0E-9;
    private static final int DEFAULT_MAX_ROW_COUNT = 10000;
    private static int iMaxRountCount = 0;
    public static final String PROPERTY_MAX_ROW_COUNT = System.getProperty("CHART_MAX_ROW");

    public static final boolean isColorTransparent(ColorDefinition cdef) {
        return cdef == null || cdef.isSetTransparency() && cdef.getTransparency() == 0;
    }

    public static final boolean isShadowDefined(Label la) {
        return !ChartUtil.isColorTransparent(la.getShadowColor());
    }

    public static final boolean mathEqual(double v1, double v2) {
        return Math.abs(v1 - v2) < 1.0E-9;
    }

    public static final boolean mathNE(double v1, double v2) {
        return Math.abs(v1 - v2) >= 1.0E-9;
    }

    public static final boolean mathLT(double lv, double rv) {
        return rv - lv > 1.0E-9;
    }

    public static final boolean mathLE(double lv, double rv) {
        return rv - lv > 1.0E-9 || Math.abs(lv - rv) < 1.0E-9;
    }

    public static final boolean mathGT(double lv, double rv) {
        return lv - rv > 1.0E-9;
    }

    public static final boolean mathGE(double lv, double rv) {
        return lv - rv > 1.0E-9 || Math.abs(lv - rv) < 1.0E-9;
    }

    public static final double convertPixelsToPoints(IDisplayServer idsSWT, double dOriginalHeight) {
        return dOriginalHeight * 72.0 / (double)idsSWT.getDpiResolution();
    }

    public static final int getQuadrant(double dAngle) {
        if ((dAngle -= (double)((int)dAngle / 360 * 360)) < 0.0) {
            dAngle += 360.0;
        }
        if (dAngle == 0.0) {
            return -1;
        }
        if (dAngle == 90.0) {
            return -2;
        }
        if (dAngle == 180.0) {
            return -3;
        }
        if (dAngle == 270.0) {
            return -4;
        }
        if (dAngle >= 0.0 && dAngle < 90.0) {
            return 1;
        }
        if (dAngle > 90.0 && dAngle < 180.0) {
            return 2;
        }
        if (dAngle > 180.0 && dAngle < 270.0) {
            return 3;
        }
        return 4;
    }

    public static boolean intersects(Polygon pg1, Polygon pg2) {
        if (pg1 != null) {
            return pg1.intersects(pg2);
        }
        return false;
    }

    public static void mergeFont(FontDefinition original, FontDefinition source) {
        if (source != null) {
            if (original.getAlignment() == null) {
                original.setAlignment(source.getAlignment());
            } else if (!original.getAlignment().isSetHorizontalAlignment() && source.getAlignment() != null) {
                original.getAlignment().setHorizontalAlignment(source.getAlignment().getHorizontalAlignment());
            }
            if (original.getName() == null) {
                original.setName(source.getName());
            }
            if (!original.isSetBold()) {
                original.setBold(source.isBold());
            }
            if (!original.isSetItalic()) {
                original.setItalic(source.isItalic());
            }
            if (!original.isSetRotation()) {
                original.setRotation(source.getRotation());
            }
            if (!original.isSetSize()) {
                original.setSize(source.getSize());
            }
            if (!original.isSetWordWrap()) {
                original.setWordWrap(source.isWordWrap());
            }
            if (!original.isSetUnderline()) {
                original.setUnderline(source.isUnderline());
            }
            if (!original.isSetStrikethrough()) {
                original.setStrikethrough(source.isStrikethrough());
            }
        }
    }

    public static String stringValue(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static Fill convertFill(Fill fill, double dValue, Fill fNegative) {
        if (dValue >= 0.0) {
            if (fill instanceof MultipleFill) {
                fill = ColorDefinitionImpl.copyInstance((ColorDefinition)((MultipleFill)fill).getFills().get(0));
            }
        } else if (fill instanceof MultipleFill) {
            fill = ColorDefinitionImpl.copyInstance((ColorDefinition)((MultipleFill)fill).getFills().get(1));
        } else if (fNegative != null) {
            fill = fNegative;
        }
        return fill;
    }

    public static Anchor transposeAnchor(Anchor an) throws IllegalArgumentException {
        if (an == null) {
            return null;
        }
        switch (an.getValue()) {
            case 0: {
                return Anchor.EAST_LITERAL;
            }
            case 4: {
                return Anchor.WEST_LITERAL;
            }
            case 2: {
                return Anchor.NORTH_LITERAL;
            }
            case 6: {
                return Anchor.SOUTH_LITERAL;
            }
            case 7: {
                return Anchor.SOUTH_EAST_LITERAL;
            }
            case 1: {
                return Anchor.NORTH_EAST_LITERAL;
            }
            case 5: {
                return Anchor.SOUTH_WEST_LITERAL;
            }
            case 3: {
                return Anchor.NORTH_WEST_LITERAL;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle().getString("exception.anchor.transpose"), new Object[]{an}));
    }

    public static TextAlignment transposeAlignment(TextAlignment ta) {
        if (ta == null) {
            return null;
        }
        HorizontalAlignment ha = ta.getHorizontalAlignment();
        VerticalAlignment va = ta.getVerticalAlignment();
        switch (ha.getValue()) {
            case 0: {
                ta.setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
                break;
            }
            case 2: {
                ta.setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
                break;
            }
            case 1: {
                ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            }
        }
        switch (va.getValue()) {
            case 2: {
                ta.setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
                break;
            }
            case 0: {
                ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
                break;
            }
            case 1: {
                ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            }
        }
        return ta;
    }

    public static int convertUnitTypeToCalendarConstant(ScaleUnitType unitType) {
        switch (unitType.getValue()) {
            case 3: {
                return 5;
            }
            case 2: {
                return 11;
            }
            case 1: {
                return 12;
            }
            case 5: {
                return 2;
            }
            case 0: {
                return 13;
            }
            case 4: {
                return 3;
            }
            case 6: {
                return 1;
            }
        }
        return -1;
    }

    public static int getSupportedMaxRowCount() {
        if (iMaxRountCount <= 0) {
            iMaxRountCount = 10000;
            if (PROPERTY_MAX_ROW_COUNT != null) {
                try {
                    iMaxRountCount = Integer.parseInt(PROPERTY_MAX_ROW_COUNT);
                }
                catch (NumberFormatException numberFormatException) {
                    iMaxRountCount = 10000;
                }
            }
            if (iMaxRountCount <= 0) {
                iMaxRountCount = 10000;
            }
        }
        return iMaxRountCount;
    }

    public static String[] getSupportedOutputFormats() throws ChartException {
        String[][] outputFormatArray = PluginSettings.instance().getRegisteredOutputFormats();
        String[] formats = new String[outputFormatArray.length];
        int i = 0;
        while (i < formats.length) {
            formats[i] = outputFormatArray[i][0];
            ++i;
        }
        return formats;
    }

    public static boolean isOutputFormatSupport(String output) throws ChartException {
        if (output == null || output.trim().length() == 0) {
            return false;
        }
        output = output.toUpperCase();
        String[] allTypes = ChartUtil.getSupportedOutputFormats();
        int i = 0;
        while (i < allTypes.length) {
            if (output.equals(allTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isRightToLeftLocale(ULocale lcl) {
        String language;
        return lcl != null && ((language = lcl.getLanguage()).equals("he") || language.equals("iw") || language.equals("ar") || language.equals("fa") || language.equals("ur") || language.equals("yi") || language.equals("ji"));
    }

    public static boolean checkDoublePrecise(double dValue) {
        if (dValue - (double)((int)dValue) == 0.0) {
            return true;
        }
        String sValue = String.valueOf(dValue);
        if (sValue.length() < 8) {
            return true;
        }
        int iPoint = sValue.indexOf(46);
        int iZero = sValue.lastIndexOf("00000000");
        if (iZero >= iPoint) {
            return false;
        }
        int iNine = sValue.lastIndexOf("99999999");
        return iNine < iPoint;
    }

    public static double computeHeightOfOrthogonalAxisTitle(ChartWithAxes cm, IDisplayServer xs) {
        double dTitleHeight = cm.getTitle().getBounds().getHeight();
        double dChartHeight = cm.getBlock().getBounds().getHeight();
        return (dChartHeight - dTitleHeight) / 72.0 * (double)xs.getDpiResolution();
    }
}

