/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.local.registry;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.Reader;
import java.util.Collection;
import org.apache.muse.core.serializer.Serializer;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DataSourceType;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.registry.util.RegistrySerializer;
import org.eclipse.cosmos.dc.local.registry.SQLProviderRegistry;
import org.eclipse.cosmos.dc.mgmt.binding.Binding;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.util.WSDMHelperRegistry;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiProviderRegistryHost
implements ProviderRegistry {
    private SqlMapClient sqlMapper;
    private ProviderRegistry delegate;

    protected void activate(ComponentContext ctx) {
        ServiceReference ref = ctx.getBundleContext().getServiceReference("org.eclipse.cosmos.dc.mgmt.common.ContributionManager");
        ContributionManager manager = (ContributionManager)ctx.getBundleContext().getService(ref);
        this.delegate = new SQLProviderRegistry();
        ((SQLProviderRegistry)this.delegate).setManager(manager);
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                Reader reader = Resources.getResourceAsReader((String)"org/eclipse/cosmos/dc/local/registry/persistence/sql/SqlMapConfig.xml");
                this.sqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader);
                ((SQLProviderRegistry)this.delegate).setSqlMapper(this.sqlMapper);
                reader.close();
                ref = ctx.getBundleContext().getServiceReference("org.eclipse.cosmos.dc.mgmt.binding.Binding");
                Binding binding = (Binding)ctx.getBundleContext().getService(ref);
                if (binding instanceof WSDMHelperRegistry) {
                    WSDMHelperRegistry helper = (WSDMHelperRegistry)binding;
                    helper.registerSerializer(DataSet.class, (Serializer)RegistrySerializer.getDataSetSerializer());
                    helper.registerSerializer(DataFlow.class, (Serializer)RegistrySerializer.getDataFlowSerializer());
                    helper.registerSerializer(DataSource.class, (Serializer)RegistrySerializer.getDataSourceSerializer());
                    helper.registerSerializer(DataSourceType.class, (Serializer)RegistrySerializer.getDataSourceTypeSerializer());
                    helper.registerSerializer(DimensionSet.class, (Serializer)RegistrySerializer.getKeySetSerializer());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.currentThread().setContextClassLoader(prevLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    public Collection<DataFlow> getAllDataFlows() throws Exception {
        return this.delegate.getAllDataFlows();
    }

    public Collection<DataSet> getAllDataSets() throws Exception {
        return this.delegate.getAllDataSets();
    }

    public Collection<DataSource> getAllDataSources() throws Exception {
        return this.delegate.getAllDataSources();
    }

    public DataFlow getDataFlow(String name) throws Exception {
        return this.delegate.getDataFlow(name);
    }

    public DataSet getDataSet(String name) throws Exception {
        return this.delegate.getDataSet(name);
    }

    public Collection<DataSet> getDataSetsForFlow(DataFlow flow) throws Exception {
        return this.delegate.getDataSetsForFlow(flow);
    }

    public Collection<DataSet> getDataSetsForFlow(String flow) throws Exception {
        return this.delegate.getDataSetsForFlow(flow);
    }

    public Collection<DataSet> getDataSetsForSource(DataSource source) throws Exception {
        return this.delegate.getDataSetsForSource(source);
    }

    public Collection<DataSet> getDataSetsForSource(String source) throws Exception {
        return this.delegate.getDataSetsForSource(source);
    }

    public DataSource getDataSource(String name) throws Exception {
        return this.delegate.getDataSource(name);
    }

    public DataSourceType getDataSourceType(String name) throws Exception {
        return this.delegate.getDataSourceType(name);
    }

    public DimensionSet getDimensionSet(String name) throws Exception {
        return this.delegate.getDimensionSet(name);
    }

    public boolean registerDataFlow(DataFlow flow) throws Exception {
        return this.delegate.registerDataFlow(flow);
    }

    public boolean registerDataSet(DataSet ds) throws Exception {
        return this.delegate.registerDataSet(ds);
    }

    public boolean registerDataSource(DataSource src) throws Exception {
        return this.delegate.registerDataSource(src);
    }

    public boolean registerDataSourceType(DataSourceType src) throws Exception {
        return this.delegate.registerDataSourceType(src);
    }

    public boolean registerDimensionSet(DimensionSet dims) throws Exception {
        return this.delegate.registerDimensionSet(dims);
    }

    public boolean updateDataSet(DataSet ds) throws Exception {
        return this.delegate.updateDataSet(ds);
    }

    public Collection<DataSet> getDataSetsForSourceKeyset(String source, String keyset) throws Exception {
        return this.delegate.getDataSetsForSourceKeyset(source, keyset);
    }

    public DataSet getLatestDataSetForSourceKeyset(String source, String keyset) throws Exception {
        return this.delegate.getLatestDataSetForSourceKeyset(source, keyset);
    }
}

