/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.stat.datamgr.client;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.dataManager.client.DataManagerClient;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.stat.datamgr.api.IStat;
import org.eclipse.cosmos.dc.stat.datamgr.client.IStatisticalClient;
import org.eclipse.cosmos.dc.stat.datamgr.client.StatisticalObservation;
import org.eclipse.cosmos.dc.stat.datamgr.client.StatisticalTuple;
import org.eclipse.cosmos.dc.stat.datamgr.common.DataSourceKeyset;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalDataManagerClient
extends DataManagerClient
implements IStatisticalClient,
IStat {
    private String _name = null;

    public StatisticalDataManagerClient() {
        super(null);
    }

    public StatisticalDataManagerClient(EndpointReference epr) {
        super(epr);
    }

    @Override
    public Collection<DataSourceKeyset> getDatasourceKeyset() throws CosmosException {
        Vector<DataSourceKeyset> ret = null;
        String[] strs = null;
        int i = 0;
        String d = null;
        String k = null;
        DataSourceKeyset tmp = null;
        ret = new Vector<DataSourceKeyset>();
        strs = this.getDatasourceKeysets();
        i = 0;
        while (i < strs.length) {
            d = strs[i++];
            k = strs[i];
            tmp = new DataSourceKeyset(d, k);
            ret.add(tmp);
            ++i;
        }
        return ret;
    }

    @Override
    public Collection<StatisticalTuple> getStatDataForSource(String dataset, String keyset, int start, int size) throws CosmosException {
        Vector<StatisticalTuple> ret = null;
        Element e = null;
        this._name = new String(dataset);
        ret = new Vector();
        e = this.getStatDataForSources(dataset, keyset, start, size);
        ret = this.MakeTuples(e);
        return ret;
    }

    public Element getStatDataForSources(String dataset, String keyset, int start, int size) throws CosmosException {
        QName q = IStat.GET_STAT_OP_QNAME;
        String op = "http://www.eclipse.org/cosmos/Statistical/getStatDataForSources";
        Element ds = null;
        Element dk = null;
        Element st = null;
        Element sz = null;
        Element e = null;
        QName tq = null;
        tq = new QName("http://www.eclipse.org/cosmos/Statistical", "dataset", "stat");
        ds = XmlUtils.createElement((QName)tq);
        ds.setTextContent(dataset);
        tq = new QName("http://www.eclipse.org/cosmos/Statistical", "keyset", "stat");
        dk = XmlUtils.createElement((QName)tq);
        dk.setTextContent(keyset);
        tq = new QName("http://www.eclipse.org/cosmos/Statistical", "start", "stat");
        st = XmlUtils.createElement((QName)tq);
        st.setTextContent(String.valueOf(start));
        tq = new QName("http://www.eclipse.org/cosmos/Statistical", "size", "stat");
        sz = XmlUtils.createElement((QName)tq);
        sz.setTextContent(String.valueOf(size));
        try {
            e = this.SendRequest(op, q, ds, dk, st, sz);
        }
        catch (DataManagerException ex) {
            throw new CosmosException("Problem sending request", (Throwable)ex);
        }
        return e;
    }

    public String[] getDatasourceKeysets() throws CosmosException {
        QName q = IStat.GET_KEYSET_OP_QNAME;
        String op = "http://www.eclipse.org/cosmos/Statistical/getDatasourceKeysets";
        Element e = null;
        String[] ret = null;
        try {
            e = this.SendRequest(op, q, null, null, null, null);
        }
        catch (DataManagerException ex) {
            throw new CosmosException("Problem sending request", (Throwable)ex);
        }
        ret = this.ProcessLF(e);
        return ret;
    }

    private String[] ProcessLF(Element e) {
        NodeList n = null;
        Element el = null;
        int i = 0;
        String s = null;
        String[] p = null;
        String[] ret = null;
        int idx = 0;
        n = e.getElementsByTagName("dyn:getDatasourceKeysetsResponseType");
        if (n.getLength() > 0) {
            p = new String[n.getLength()];
        }
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1 && (s = XmlUtils.extractText((Element)(el = (Element)n.item(i)))).length() > 0) {
                p[idx++] = new String(s);
            }
            ++i;
        }
        ret = new String[idx];
        i = 0;
        while (i < idx) {
            ret[i] = new String(p[i]);
            ++i;
        }
        return ret;
    }

    private Element SendRequest(String operation, QName qstr, Element ds, Element ks, Element st, Element sz) throws DataManagerException {
        Element parm;
        Element soapBody = XmlUtils.createElement((QName)qstr);
        if (ds != null) {
            parm = XmlUtils.createElement((QName)IStat.GET_STAT_DATASET_QNAME);
            parm.appendChild(ds);
            soapBody.appendChild(ds);
        }
        if (ks != null) {
            parm = XmlUtils.createElement((QName)IStat.GET_STAT_KEYSET_QNAME);
            parm.appendChild(ks);
            soapBody.appendChild(ks);
        }
        if (st != null) {
            parm = XmlUtils.createElement((QName)IStat.GET_STAT_START_QNAME);
            parm.appendChild(st);
            soapBody.appendChild(st);
        }
        if (sz != null) {
            parm = XmlUtils.createElement((QName)IStat.GET_STAT_SIZE_QNAME);
            parm.appendChild(sz);
            soapBody.appendChild(sz);
        }
        try {
            Element results = this.invoke(operation, soapBody);
            return results;
        }
        catch (SoapFault e) {
            throw new DataManagerException((Throwable)e);
        }
    }

    private Collection<StatisticalTuple> MakeTuples(Element e) {
        Vector<StatisticalTuple> ret = null;
        NodeList n = null;
        int i = 0;
        Element el = null;
        StatisticalObservation ob = null;
        Date od = null;
        Date cd = null;
        StatisticalTuple t = null;
        ret = new Vector<StatisticalTuple>();
        n = e.getElementsByTagName("stat:observation");
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1) {
                el = (Element)n.item(i);
                ob = this.MakeStatObj(el);
                od = this.GetDate(el);
                if (od == null) {
                    return null;
                }
                if (cd == null) {
                    t = new StatisticalTuple();
                    t.setTimeStamp(od);
                    t.add(ob);
                    ret.add(t);
                } else if (od.equals(cd)) {
                    t.add(ob);
                } else {
                    t = new StatisticalTuple();
                    t.setTimeStamp(od);
                    t.add(ob);
                    ret.add(t);
                }
                cd = od;
            }
            ++i;
        }
        return ret;
    }

    private Date GetDate(Element e) {
        NodeList n = null;
        Date ret = null;
        int i = 0;
        String s = null;
        Element el = null;
        n = e.getElementsByTagName("stat:date");
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1) {
                el = (Element)n.item(i);
                s = XmlUtils.extractText((Element)el);
                try {
                    System.out.println("S = " + s);
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
                    ret = sd.parse(s);
                }
                catch (Exception ex) {
                    System.out.println("Invalid date " + s);
                    System.out.println(ex.getMessage());
                    return null;
                }
            }
            ++i;
        }
        return ret;
    }

    private StatisticalObservation MakeStatObj(Element e) {
        Element el;
        NodeList n = null;
        int i = 0;
        String str = null;
        String s = null;
        Long ivalue = null;
        Double dvalue = null;
        StatisticalObservation ret = null;
        Object obj = null;
        n = e.getElementsByTagName("stat:string");
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1 && !(str = XmlUtils.extractText((Element)(el = (Element)n.item(i)))).equals("<NULL>")) {
                obj = str;
            }
            ++i;
        }
        n = e.getElementsByTagName("stat:integer");
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1) {
                el = (Element)n.item(i);
                s = XmlUtils.extractText((Element)el);
                ivalue = Long.valueOf(s);
                if (obj == null && ivalue != 0L) {
                    obj = ivalue;
                }
            }
            ++i;
        }
        n = e.getElementsByTagName("stat:double");
        i = 0;
        while (i < n.getLength()) {
            if (n.item(i).getNodeType() == 1) {
                el = (Element)n.item(i);
                s = XmlUtils.extractText((Element)el);
                dvalue = Double.valueOf(s);
                if (obj == null && dvalue != 0.0) {
                    obj = dvalue;
                }
            }
            ++i;
        }
        ret = new StatisticalObservation(this._name, obj);
        return ret;
    }
}

