/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeMaterializer;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.ICubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.data.adapter.impl.CubeQueryUtil;
import org.eclipse.birt.report.data.adapter.impl.DataSetIterator;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.data.adapter.impl.ModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.mozilla.javascript.Scriptable;

public class DataRequestSessionImpl
extends DataRequestSession {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DataRequestSessionImpl(DataSessionContext context) throws BirtException {
        if (context == null) {
            throw new AdapterException("context.null.error");
        }
        this.dataEngine = DataEngine.newDataEngine((DataEngineContext)context.getDataEngineContext());
        this.modelAdaptor = new ModelAdapter(context);
        this.sessionContext = context;
    }

    public void defineDataSource(IBaseDataSourceDesign design) throws BirtException {
        this.dataEngine.defineDataSource(design);
    }

    public void defineDataSet(IBaseDataSetDesign design) throws BirtException {
        this.dataEngine.defineDataSet(design);
    }

    public IResultMetaData getDataSetMetaData(String dataSetName, boolean useCache) throws BirtException {
        return this.getDataSetMetaData(this.sessionContext.getModuleHandle().findDataSet(dataSetName), useCache);
    }

    public IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).getDataSetMetaData(dataSetHandle, useCache);
    }

    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        return this.getColumnValueSet(dataSet, inputParamBindings, columnBindings, boundColumnName, null);
    }

    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        Object value;
        ArrayList temp = new ArrayList();
        while (columnBindings.hasNext()) {
            temp.add(columnBindings.next());
        }
        if (this.referToAggregation(temp, boundColumnName)) {
            return new ArrayList();
        }
        IQueryResults queryResults = this.getGroupingQueryResults(dataSet, inputParamBindings, temp.iterator(), boundColumnName);
        IResultIterator resultIt = queryResults.getResultIterator();
        int maxRowCount = -1;
        ArrayList<Object> values = new ArrayList<Object>();
        if (requestInfo != null) {
            if (requestInfo.getStartRow() >= 0) {
                resultIt.moveTo(requestInfo.getStartRow());
                value = resultIt.getValue(boundColumnName);
                values.add(value);
            }
            maxRowCount = requestInfo.getMaxRow();
        }
        while (resultIt.next() && maxRowCount != 0) {
            value = resultIt.getValue(boundColumnName);
            values.add(value);
            resultIt.skipToEnd(1);
            --maxRowCount;
        }
        resultIt.close();
        queryResults.close();
        return values;
    }

    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).refreshMetaData(dataSetHandle);
    }

    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).refreshMetaData(dataSetHandle, holdEvent);
    }

    public IQueryResults executeQuery(QueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt) throws BirtException {
        return new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).executeQuery(queryDefn, paramBindingIt, filterIt, bindingIt);
    }

    public IQueryResults getQueryResults(String queryResultID) throws BirtException {
        return this.dataEngine.getQueryResults(queryResultID);
    }

    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        this.dataEngine.clearCache(dataSource, dataSet);
    }

    public IPreparedQuery prepare(IQueryDefinition query, Map appContext) throws BirtException {
        if (appContext == null) {
            appContext = this.sessionContext.getAppContext();
        }
        return this.dataEngine.prepare(query, appContext);
    }

    public IPreparedQuery prepare(IQueryDefinition query) throws BirtException {
        return this.dataEngine.prepare(query, this.sessionContext.getAppContext());
    }

    public void closeDataSource(String dataSourceName) throws BirtException {
        this.dataEngine.closeDataSource(dataSourceName);
    }

    public IModelAdapter getModelAdaptor() {
        return this.modelAdaptor;
    }

    public void shutdown() {
        this.dataEngine.shutdown();
        this.dataEngine = null;
    }

    private IQueryResults getGroupingQueryResults(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        if (!$assertionsDisabled && dataSet == null) {
            throw new AssertionError();
        }
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSet.getQualifiedName());
        GroupDefinition group = new GroupDefinition(boundColumnName);
        group.setKeyColumn(boundColumnName);
        query.addGroup(group);
        query.setUsesDetails(false);
        ModuleHandle moduleHandle = this.sessionContext.getModuleHandle();
        if (moduleHandle == null) {
            moduleHandle = dataSet.getModuleHandle();
        }
        QueryExecutionHelper execHelper = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext);
        IQueryResults results = execHelper.executeQuery(query, inputParamBindings, null, columnBindings);
        return results;
    }

    private boolean referToAggregation(List bindings, String boundColumnName) throws BirtException {
        if (boundColumnName == null) {
            return true;
        }
        Iterator columnBindings = bindings.iterator();
        while (columnBindings != null && columnBindings.hasNext()) {
            ComputedColumn column = this.modelAdaptor.adaptComputedColumn((ComputedColumnHandle)columnBindings.next());
            if (!column.getName().equals(boundColumnName)) continue;
            ScriptExpression sxp = (ScriptExpression)column.getExpression();
            if (ExpressionUtil.hasAggregation((String)sxp.getText())) {
                return true;
            }
            Iterator columnBindingNameIt = ExpressionUtil.extractColumnExpressions((String)sxp.getText()).iterator();
            while (columnBindingNameIt.hasNext()) {
                IColumnBinding columnBinding = (IColumnBinding)columnBindingNameIt.next();
                if (!this.referToAggregation(bindings, columnBinding.getResultSetColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    public IBaseQueryResults execute(IBasePreparedQuery query, IBaseQueryResults outerResults, Scriptable scope) throws AdapterException {
        try {
            if (query instanceof IPreparedQuery) {
                return ((IPreparedQuery)query).execute(outerResults instanceof IQueryResults ? (IQueryResults)outerResults : null, scope);
            }
            if (query instanceof IPreparedCubeQuery) {
                return ((IPreparedCubeQuery)query).execute(scope);
            }
            return null;
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage());
        }
    }

    public IBasePreparedQuery prepare(IDataQueryDefinition query, Map appContext) throws AdapterException {
        try {
            if (query instanceof IQueryDefinition) {
                return this.prepare((IQueryDefinition)query, appContext == null ? this.sessionContext.getAppContext() : appContext);
            }
            if (query instanceof ICubeQueryDefinition) {
                return this.prepare((ICubeQueryDefinition)query);
            }
            return null;
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage());
        }
    }

    public void defineCube(CubeHandle cubeHandle) throws BirtException {
        int mode = this.sessionContext.getDataEngineContext().getMode();
        try {
            CubeMaterializer cubeMaterializer = null;
            if (mode == 3) {
                cubeMaterializer = this.createCubeMaterializer(cubeHandle);
                this.createCube((TabularCubeHandle)cubeHandle, cubeMaterializer);
                cubeMaterializer.close();
            } else if (mode == 1) {
                cubeMaterializer = this.createCubeMaterializer(cubeHandle);
                this.createCube((TabularCubeHandle)cubeHandle, cubeMaterializer);
                cubeMaterializer.saveCubeToReportDocument(cubeHandle.getQualifiedName(), this.sessionContext.getDocumentWriter(), null);
                cubeMaterializer.close();
            }
        }
        catch (Exception e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    private CubeMaterializer createCubeMaterializer(CubeHandle cubeHandle) throws DataException, IOException, BirtException {
        CubeMaterializer cubeMaterializer = new CubeMaterializer(String.valueOf(this.sessionContext.getDataEngineContext().getTmpdir()) + this.dataEngine.hashCode(), cubeHandle.getQualifiedName());
        return cubeMaterializer;
    }

    private void createCube(TabularCubeHandle cubeHandle, CubeMaterializer cubeMaterializer) throws IOException, BirtException, DataException {
        ArrayList<String> measureNames = new ArrayList<String>();
        List measureGroups = cubeHandle.getContents("measureGroups");
        int i = 0;
        while (i < measureGroups.size()) {
            MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i);
            List measures = mgh.getContents("measures");
            int j = 0;
            while (j < measures.size()) {
                MeasureHandle measure = (MeasureHandle)measures.get(j);
                measureNames.add(measure.getName());
                ++j;
            }
            ++i;
        }
        IDimension[] dimensions = this.populateDimensions(cubeMaterializer, cubeHandle);
        String[][] factTableKey = new String[dimensions.length][];
        String[][] dimensionKey = new String[dimensions.length][];
        int i2 = 0;
        while (i2 < dimensions.length) {
            TabularDimensionHandle dim = (TabularDimensionHandle)cubeHandle.getDimension(dimensions[i2].getName());
            TabularHierarchyHandle hier = (TabularHierarchyHandle)dim.getDefaultHierarchy();
            if (cubeHandle.getDataSet().equals(hier.getDataSet())) {
                String[] keyNames = dimensions[i2].getHierarchy().getLevels()[dimensions[i2].getHierarchy().getLevels().length - 1].getKeyNames();
                int j = 0;
                while (j < keyNames.length) {
                    keyNames[j] = String.valueOf(dimensions[i2].getName()) + "/" + keyNames[j];
                    ++j;
                }
                factTableKey[i2] = keyNames;
                dimensionKey[i2] = factTableKey[i2];
            } else {
                Iterator it = cubeHandle.joinConditionsIterator();
                if (!it.hasNext()) {
                    throw new AdapterException("missing.join.condition", dim.getName());
                }
                boolean foundJoinCondition = false;
                while (it.hasNext()) {
                    DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
                    if (!dimCondHandle.getHierarchy().equals(hier)) continue;
                    Iterator conditionIt = dimCondHandle.getJoinConditions().iterator();
                    ArrayList<String> dimensionKeys = new ArrayList<String>();
                    ArrayList<String> factTableKeys = new ArrayList<String>();
                    while (conditionIt.hasNext()) {
                        foundJoinCondition = true;
                        DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)conditionIt.next();
                        String levelName = joinCondition.getLevelName();
                        if (levelName != null && this.isAttribute(dimensions[i2], levelName, joinCondition.getHierarchyKey())) {
                            dimensionKeys.add(OlapExpressionUtil.getAttributeColumnName((String)this.getLevelName(dimensions[i2], levelName), (String)joinCondition.getHierarchyKey()));
                        } else {
                            dimensionKeys.add(joinCondition.getHierarchyKey());
                        }
                        factTableKeys.add(OlapExpressionUtil.getQualifiedLevelName((String)dimensions[i2].getName(), (String)joinCondition.getCubeKey()));
                    }
                    factTableKey[i2] = new String[factTableKeys.size()];
                    dimensionKey[i2] = new String[dimensionKeys.size()];
                    int j = 0;
                    while (j < dimensionKeys.size()) {
                        factTableKey[i2][j] = factTableKeys.get(j).toString();
                        dimensionKey[i2][j] = dimensionKeys.get(j).toString();
                        ++j;
                    }
                }
                if (!foundJoinCondition) {
                    throw new AdapterException("missing.join.condition", dim.getName());
                }
            }
            ++i2;
        }
        cubeMaterializer.createCube(cubeHandle.getQualifiedName(), factTableKey, dimensionKey, dimensions, (IDatasetIterator)new DataSetIterator(this, cubeHandle), this.toStringArray(measureNames), null);
    }

    private boolean isAttribute(IDimension dimension, String levelName, String colName) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int j = 0;
        while (j < levels.length) {
            String[] attributes;
            if (levelName.equals(OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)levels[j].getName())) && (attributes = levels[j].getAttributeNames()) != null) {
                int k = 0;
                while (k < attributes.length) {
                    if (attributes[k].equals(OlapExpressionUtil.getAttributeColumnName((String)levels[j].getName(), (String)colName))) {
                        return true;
                    }
                    ++k;
                }
            }
            ++j;
        }
        return false;
    }

    private String getLevelName(IDimension dimension, String targetName) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int j = 0;
        while (j < levels.length) {
            if (targetName.equals(OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)levels[j].getName()))) {
                return levels[j].getName();
            }
            ++j;
        }
        return targetName;
    }

    private IDimension[] populateDimensions(CubeMaterializer cubeMaterializer, TabularCubeHandle cubeHandle) throws IOException, BirtException, DataException {
        List dimHandles = cubeHandle.getContents("dimensions");
        ArrayList<IDimension> result = new ArrayList<IDimension>();
        int i = 0;
        while (i < dimHandles.size()) {
            result.add(this.populateDimension(cubeMaterializer, (DimensionHandle)dimHandles.get(i), cubeHandle));
            ++i;
        }
        IDimension[] dimArray = new IDimension[dimHandles.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            dimArray[i2] = (IDimension)result.get(i2);
            ++i2;
        }
        return dimArray;
    }

    private IDimension populateDimension(CubeMaterializer cubeMaterializer, DimensionHandle dim, TabularCubeHandle cubeHandle) throws IOException, BirtException, DataException {
        List hiers = dim.getContents("hierarchies");
        ArrayList<IHierarchy> iHiers = new ArrayList<IHierarchy>();
        int j = 0;
        while (j < hiers.size()) {
            TabularHierarchyHandle hierhandle = (TabularHierarchyHandle)hiers.get(0);
            List levels = hierhandle.getContents("levels");
            ILevelDefn[] levelInHier = null;
            levelInHier = hierhandle.getLevelCount() == 1 ? new ILevelDefn[1] : new ILevelDefn[hierhandle.getLevelCount() + 1];
            String[] leafLevelKeyColumn = new String[levels.size()];
            int k = 0;
            while (k < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(k);
                ArrayList<String> levelKeys = new ArrayList<String>();
                Iterator it = level.attributesIterator();
                while (it.hasNext()) {
                    LevelAttributeHandle levelAttr = (LevelAttributeHandle)it.next();
                    levelKeys.add(OlapExpressionUtil.getAttributeColumnName((String)level.getName(), (String)levelAttr.getName()));
                }
                if (level.getDisplayColumnName() != null) {
                    levelKeys.add(OlapExpressionUtil.getDisplayColumnName((String)level.getName()));
                }
                leafLevelKeyColumn[k] = level.getName();
                levelInHier[k] = CubeElementFactory.createLevelDefinition((String)level.getName(), (String[])new String[]{level.getName()}, (String[])this.toStringArray(levelKeys));
                ++k;
            }
            this.createLeafLevel(levels, levelInHier, leafLevelKeyColumn);
            iHiers.add(cubeMaterializer.createHierarchy(dim.getName(), hierhandle.getName(), (IDatasetIterator)new DataSetIterator(this, hierhandle), levelInHier));
            ++j;
        }
        return cubeMaterializer.createDimension(dim.getName(), (IHierarchy)iHiers.get(0));
    }

    private void createLeafLevel(List levels, ILevelDefn[] levelInHier, String[] leafLevelKeyColumn) {
        if (levelInHier.length > levels.size()) {
            levelInHier[levelInHier.length - 1] = CubeElementFactory.createLevelDefinition((String)"_${INTERNAL_INDEX}$_", (String[])leafLevelKeyColumn, (String[])new String[0]);
        }
    }

    private String[] toStringArray(List object) {
        String[] result = new String[object.size()];
        int i = 0;
        while (i < object.size()) {
            result[i] = object.get(i).toString();
            ++i;
        }
        return result;
    }

    public IPreparedCubeQuery prepare(ICubeQueryDefinition query) throws BirtException {
        return this.dataEngine.prepare(query, null);
    }

    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.dataEngine.getCachedDataSetMetaData(dataSource, dataSet);
    }

    public ICubeQueryUtil getCubeQueryUtil() {
        return new CubeQueryUtil(this);
    }

    public Scriptable getScope() throws AdapterException {
        try {
            return this.sessionContext.getDataEngineContext().getJavaScriptScope();
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }
}

