/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.util.UnicodeUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ModuleReader {
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.parser.ModuleReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.model.parser.ModuleReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    /*
     * Unable to fully structure code
     */
    protected Module readModule(ModuleParserHandler handler, InputStream inputStream) throws DesignFileException {
        if (!ModuleReader.$assertionsDisabled && handler == null) {
            throw new AssertionError();
        }
        internalStream = inputStream;
        if (!inputStream.markSupported()) {
            internalStream = new BufferedInputStream(inputStream);
        }
        if (!ModuleReader.$assertionsDisabled && !internalStream.markSupported()) {
            throw new AssertionError();
        }
        signature = null;
        try {
            signature = ModuleReader.checkUTFSignature(internalStream, handler.getFileName());
            saxParserFactory = SAXParserFactory.newInstance();
            parser = saxParserFactory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", new ModuleParserHandler.ModuleLexicalHandler(handler));
            inputSource = new InputSource(internalStream);
            inputSource.setEncoding(signature);
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            errors = handler.getErrorHandler().getErrors();
            i = 0;
            ** while (i < errors.size())
        }
lbl-1000:
        // 1 sources

        {
            exception = (Exception)errors.get(i);
            ModuleReader.logger.log(Level.SEVERE, exception.getMessage());
            ++i;
            continue;
        }
lbl27:
        // 1 sources

        if (e.getException() instanceof DesignFileException) {
            throw (DesignFileException)e.getException();
        }
        throw new DesignFileException(handler.getFileName(), errors, e);
        catch (ParserConfigurationException e) {
            throw new DesignFileException(handler.getFileName(), handler.getErrorHandler().getErrors(), e);
        }
        catch (IOException e) {
            ModuleReader.logger.log(Level.SEVERE, "IO error occurs" + e.getLocalizedMessage());
            throw new DesignFileException(handler.getFileName(), handler.getErrorHandler().getErrors(), e);
        }
        module = handler.getModule();
        module.setUTFSignature(signature);
        module.setValid(true);
        return module;
    }

    public Module readModule(ModuleParserHandler handler) throws DesignFileException {
        if (!$assertionsDisabled && handler == null) {
            throw new AssertionError();
        }
        URL url = null;
        try {
            url = new URL(handler.getFileName());
        }
        catch (MalformedURLException malformedURLException) {}
        InputStream in = null;
        try {
            in = url != null ? url.openStream() : new FileInputStream(handler.getFileName());
        }
        catch (IOException iOException) {
            DesignParserException ex = new DesignParserException(new String[]{handler.getFileName()}, "Error.DesignParserException.FILE_NOT_FOUND");
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            logger.log(Level.SEVERE, "Parsed file was not found.");
            throw new DesignFileException(handler.getFileName(), exceptionList);
        }
        BufferedInputStream inputStream = new BufferedInputStream(in);
        if (!$assertionsDisabled && !((InputStream)inputStream).markSupported()) {
            throw new AssertionError();
        }
        Module module = this.readModule(handler, inputStream);
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException iOException) {}
        inputStream = null;
        return module;
    }

    protected static String checkUTFSignature(InputStream inputStream, String fileName) throws IOException, SAXException {
        String encoding = UnicodeUtil.checkUTFSignature(inputStream);
        if (encoding != null && !"UTF-8".equals(encoding)) {
            DesignParserException cause = new DesignParserException("Error.DesignParserException.UNSUPPORTED_ENCODING");
            DesignFileException fileException = new DesignFileException(fileName, (Exception)((Object)cause));
            throw new SAXException((Exception)((Object)fileException));
        }
        return encoding;
    }
}

