/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.util.uuid;

import java.security.SecureRandom;
import org.apache.muse.util.uuid.UuidFactory;

public class RandomUuidFactory
implements UuidFactory {
    private static final RandomUuidFactory _SINGLETON = new RandomUuidFactory();
    private static final char[] _HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final SecureRandom _RNG = new SecureRandom();

    private RandomUuidFactory() {
    }

    public String createUUID() {
        byte[] bytes = new byte[16];
        _RNG.nextBytes(bytes);
        StringBuffer uuid = new StringBuffer(41);
        uuid.append("uuid:");
        for (int n = 0; n < 16; ++n) {
            if (n == 4 || n == 6 || n == 8 || n == 10) {
                uuid.append('-');
            }
            int hex = bytes[n] & 0xFF;
            uuid.append(_HEX_VALUES[hex >> 4]);
            uuid.append(_HEX_VALUES[hex & 0xF]);
        }
        return uuid.toString();
    }

    public static RandomUuidFactory getInstance() {
        return _SINGLETON;
    }
}

