/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import java.text.ParseException;
import java.util.Date;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.StateTransition;
import org.apache.muse.ws.dm.muws.StateType;
import org.apache.muse.ws.dm.muws.impl.SimpleStateType;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleStateTransition
implements StateTransition {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition = SimpleStateTransition.class$("org.apache.muse.ws.dm.muws.impl.SimpleStateTransition")) : class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition);
    private StateType _entered = null;
    private StateType _previous = null;
    private Date _transitionTime = new Date();
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition;

    public SimpleStateTransition(Element xml) throws BaseFault {
        Element enteredXML;
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullSTElement"));
        }
        String timeString = xml.getAttribute("Time");
        if (timeString == null || timeString.length() == 0) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoTransitionTime"));
        }
        try {
            this._transitionTime = XsdUtils.getLocalTime(timeString);
        }
        catch (ParseException error) {
            throw new InvalidMessageFormatFault(error);
        }
        Element previousXML = XmlUtils.getElement(xml, MuwsConstants.PREVIOUS_QNAME);
        if (previousXML != null) {
            this._previous = new SimpleStateType(previousXML);
        }
        if ((enteredXML = XmlUtils.getElement(xml, MuwsConstants.ENTERED_QNAME)) == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoEnteredState"));
        }
        this._entered = new SimpleStateType(enteredXML);
    }

    public SimpleStateTransition(StateType previous, StateType entered) {
        if (entered == null) {
            throw new NullPointerException(_MESSAGES.get("NullState"));
        }
        this._previous = previous;
        this._entered = entered;
    }

    public StateType getEnteredState() {
        return this._entered;
    }

    public StateType getPreviousState() {
        return this._previous;
    }

    public Date getTransitionTime() {
        return this._transitionTime;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement(doc, MuwsConstants.TRANSITION_QNAME);
        Date time = this.getTransitionTime();
        root.setAttribute("Time", XsdUtils.getLocalTimeString(time));
        StateType previous = this.getPreviousState();
        if (previous != null) {
            Element previousXML = previous.toXML(doc);
            XmlUtils.setElement(root, MuwsConstants.PREVIOUS_QNAME, previousXML, true);
        }
        StateType entered = this.getEnteredState();
        Element enteredXML = entered.toXML(doc);
        XmlUtils.setElement(root, MuwsConstants.ENTERED_QNAME, enteredXML, true);
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

