/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.MonitoringParser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;
import org.eclipse.hyades.logging.parsers.util.FilterExitHelper;

public abstract class AbstractErrorLogParser
extends MonitoringParser {
    protected String category = null;
    protected short severity = 0;
    protected String clientIP = null;
    protected String message = null;
    protected String fileName = null;
    protected StringBuffer cgiDebuggingOutput = new StringBuffer();
    protected StringBuffer currentTimeStamp = null;
    protected String productVersion = null;
    protected String sourceID = null;
    private long duplicateTimeStampCounter = 0L;
    private String previousTimeStamp = EventHelpers.longToDate((long)0L);
    private SimpleDateFormat SDFformatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat SDFparser = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    protected FilterExitHelper sensorFilterExitHelper = new FilterExitHelper();

    public void setConfiguration(Hashtable table) throws LogParserException {
        super.setConfiguration(table);
        this.sensorFilterExitHelper.init(table, this.filterExitClassInstance);
    }

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public void postParse() throws LogParserException {
        super.postParse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommonBaseEvent[] parseNext() throws LogParserException {
        CommonBaseEvent[] temp = null;
        this.curLine = this.readALine();
        this.arrayIndex = 0;
        try {
            block25: {
                while (true) {
                    if (this.curLine == null) {
                        if (this.cgiDebuggingOutput.length() > 0) {
                            if (this.recordCount != 0) break;
                            throw new LogParserException(ParserUtilities.getResourceString("INVALID_ERROR_LOG_ERROR_", this.file_path));
                        }
                        break block25;
                    }
                    this.curLine = this.curLine.trim();
                    if (this.curLine.length() > 0) {
                        if (this.filterExitClassInstance != null) {
                            try {
                                boolean pass = this.filterExitClassInstance.filter(this.curLine);
                                if (!pass) {
                                    this.curLine = this.readALine();
                                    continue;
                                }
                            }
                            catch (AdapterException adapterException) {
                                throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_FILTERING_ERROR_", this.curLine));
                            }
                        }
                        if (this.parseLogRecord()) {
                            if (this.cgiDebuggingOutput.length() > 0) {
                                this.createCGIDebuggingOutputCBE();
                                ++this.arrayIndex;
                                if (this.arrayIndex == this.MessageArraySize) {
                                    this.increaseMsgArraySize();
                                }
                                ++this.recordCount;
                            }
                            this.reinitializeCBE();
                            if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                                this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                            } else {
                                this.previousTimeStamp = this.currentTimeStamp.toString();
                                this.duplicateTimeStampCounter = 0L;
                                this.messages[this.arrayIndex].setSequenceNumber(this.duplicateTimeStampCounter);
                            }
                            this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                            this.messages[this.arrayIndex].setMsg(this.message);
                            this.messages[this.arrayIndex].setSeverity(this.severity);
                            if (this.category != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractErrorLogParser.createStringEDE("category", this.category));
                            }
                            if (this.clientIP != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractErrorLogParser.createStringEDE("client", this.clientIP));
                            }
                            if (this.fileName != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractErrorLogParser.createStringEDE("file", this.fileName));
                            }
                            ++this.arrayIndex;
                            if (this.arrayIndex == this.MessageArraySize) {
                                this.arrayIndex = 0;
                                ++this.recordCount;
                                this.reset();
                                return this.messages;
                            }
                            ++this.recordCount;
                            this.reset();
                        }
                    }
                    this.curLine = this.readALine();
                }
                this.createCGIDebuggingOutputCBE();
                ++this.arrayIndex;
                if (this.arrayIndex == this.MessageArraySize) {
                    this.arrayIndex = 0;
                    ++this.recordCount;
                    this.reset();
                    return this.messages;
                }
                this.cgiDebuggingOutput = new StringBuffer();
                ++this.recordCount;
            }
            if (this.arrayIndex == 0) {
                temp = null;
                this.setEndOfFile();
            } else {
                int i = this.arrayIndex;
                while (true) {
                    if (i >= this.MessageArraySize) {
                        temp = this.messages;
                        break;
                    }
                    this.messages[i] = null;
                    ++i;
                }
            }
            if (this.recordCount != 0) return temp;
            throw new LogParserException(ParserUtilities.getResourceString("NO_ERROR_LOG_RECORDS_ERROR_", this.file_path));
        }
        catch (LogParserException l) {
            throw l;
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ERROR_LOG_PARSER_ERROR_"));
        }
        return temp;
    }

    private void createCGIDebuggingOutputCBE() {
        this.reinitializeCBE();
        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
        this.messages[this.arrayIndex].setCreationTime(this.previousTimeStamp);
        this.messages[this.arrayIndex].setMsg(this.cgiDebuggingOutput.toString().trim());
        this.messages[this.arrayIndex].setSeverity((short)10);
        this.messages[this.arrayIndex].addExtendedDataElement(AbstractErrorLogParser.createStringEDE("CGI_debugging_output", this.cgiDebuggingOutput.toString().trim()));
    }

    private void reinitializeCBE() {
        if (this.messages[this.arrayIndex] == null) {
            this.messages[this.arrayIndex] = eventFactory.createCommonBaseEvent();
        }
        this.messages[this.arrayIndex].init();
        this.messages[this.arrayIndex].setGlobalInstanceId(Guid.generate());
        ComponentIdentification sourceComponentID = eventFactory.createComponentIdentification();
        sourceComponentID.setLocation(this.localHostId);
        sourceComponentID.setLocationType(this.localHostIdFormat);
        sourceComponentID.setComponent(this.sourceID);
        sourceComponentID.setSubComponent("Unknown");
        sourceComponentID.setComponentType("HTTPServer");
        sourceComponentID.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(sourceComponentID);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private Situation createSituation() {
        Situation cbeSituation = eventFactory.createSituation();
        if (this.curLine.indexOf("Initializing") >= 0 || this.curLine.indexOf("Starting") >= 0) {
            StartSituation cbeStartSituation = eventFactory.createStartSituation();
            cbeStartSituation.setReasoningScope("INTERNAL");
            cbeStartSituation.setSuccessDisposition("SUCCESSFUL");
            cbeStartSituation.setSituationQualifier("START INITIATED");
            cbeSituation.setCategoryName("StartSituation");
            cbeSituation.setSituationType((SituationType)cbeStartSituation);
        } else if (this.curLine.indexOf("Attempting to restart") >= 0) {
            StartSituation cbeStartSituation = eventFactory.createStartSituation();
            cbeStartSituation.setReasoningScope("INTERNAL");
            cbeStartSituation.setSuccessDisposition("SUCCESSFUL");
            cbeStartSituation.setSituationQualifier("RESTART INITIATED");
            cbeSituation.setCategoryName("StartSituation");
            cbeSituation.setSituationType((SituationType)cbeStartSituation);
        } else if (this.curLine.indexOf("process is running") >= 0) {
            StartSituation cbeStartSituation = eventFactory.createStartSituation();
            cbeStartSituation.setReasoningScope("INTERNAL");
            cbeStartSituation.setSuccessDisposition("SUCCESSFUL");
            cbeStartSituation.setSituationQualifier("START COMPLETED");
            cbeSituation.setCategoryName("StartSituation");
            cbeSituation.setSituationType((SituationType)cbeStartSituation);
        } else if (this.curLine.indexOf("[error]") >= 0) {
            RequestSituation cbeRequestSituation = eventFactory.createRequestSituation();
            cbeRequestSituation.setReasoningScope("EXTERNAL");
            cbeRequestSituation.setSuccessDisposition("UNSUCCESSFUL");
            cbeRequestSituation.setSituationQualifier("REQUEST INITIATED");
            cbeSituation.setCategoryName("RequestSituation");
            cbeSituation.setSituationType((SituationType)cbeRequestSituation);
        } else if (this.curLine.indexOf("Acquired the start mutex") >= 0 || this.curLine.indexOf("Released the start mutex") >= 0) {
            RequestSituation cbeRequestSituation = eventFactory.createRequestSituation();
            cbeRequestSituation.setReasoningScope("INTERNAL");
            cbeRequestSituation.setSuccessDisposition("SUCCESSFUL");
            cbeRequestSituation.setSituationQualifier("REQUEST COMPLETED");
            cbeSituation.setCategoryName("RequestSituation");
            cbeSituation.setSituationType((SituationType)cbeRequestSituation);
        } else if (this.curLine.indexOf("suEXEC mechanism enabled") >= 0) {
            FeatureSituation cbeFeatureSituation = eventFactory.createFeatureSituation();
            cbeFeatureSituation.setReasoningScope("INTERNAL");
            cbeFeatureSituation.setFeatureDisposition("AVAILABLE");
            cbeSituation.setCategoryName("FeatureSituation");
            cbeSituation.setSituationType((SituationType)cbeFeatureSituation);
        } else if (this.curLine.indexOf("DAV/2 configured") >= 0) {
            ConfigureSituation cbeConfigureSituation = eventFactory.createConfigureSituation();
            cbeConfigureSituation.setReasoningScope("INTERNAL");
            cbeConfigureSituation.setSuccessDisposition("SUCCESSFUL");
            cbeSituation.setCategoryName("ConfigureSituation");
            cbeSituation.setSituationType((SituationType)cbeConfigureSituation);
        } else if (this.curLine.matches(".*[Ss]hutting down.*")) {
            StopSituation cbeStopSituation = eventFactory.createStopSituation();
            cbeStopSituation.setReasoningScope("INTERNAL");
            cbeStopSituation.setSituationQualifier("ABORT INITIATED");
            cbeStopSituation.setSuccessDisposition("SUCCESSFUL");
            cbeSituation.setCategoryName("StopSituation");
            cbeSituation.setSituationType((SituationType)cbeStopSituation);
        } else if (this.curLine.matches(".*(is\\s(ending|exiting)|Waiting\\sfor.*to\\sexit).*")) {
            StopSituation cbeStopSituation = eventFactory.createStopSituation();
            cbeStopSituation.setReasoningScope("INTERNAL");
            cbeStopSituation.setSituationQualifier("STOP INITIATED");
            cbeStopSituation.setSuccessDisposition("SUCCESSFUL");
            cbeSituation.setCategoryName("StopSituation");
            cbeSituation.setSituationType((SituationType)cbeStopSituation);
        } else if (this.curLine.indexOf("have exited") >= 0 || this.curLine.indexOf("exited successfully") >= 0) {
            StopSituation cbeStopSituation = eventFactory.createStopSituation();
            cbeStopSituation.setReasoningScope("INTERNAL");
            cbeStopSituation.setSituationQualifier("STOP COMPLETED");
            cbeStopSituation.setSuccessDisposition("SUCCESSFUL");
            cbeSituation.setCategoryName("StopSituation");
            cbeSituation.setSituationType((SituationType)cbeStopSituation);
        } else if (this.curLine.indexOf("Created process") >= 0) {
            CreateSituation cbeCreateSituation = eventFactory.createCreateSituation();
            cbeCreateSituation.setReasoningScope("INTERNAL");
            cbeCreateSituation.setSuccessDisposition("SUCCESSFUL");
            cbeSituation.setCategoryName("CreateSituation");
            cbeSituation.setSituationType((SituationType)cbeCreateSituation);
        } else {
            ReportSituation cbeReportSituation = eventFactory.createReportSituation();
            cbeReportSituation.setReasoningScope("INTERNAL");
            cbeReportSituation.setReportCategory("LOG");
            cbeSituation.setCategoryName("ReportSituation");
            cbeSituation.setSituationType((SituationType)cbeReportSituation);
        }
        return cbeSituation;
    }

    protected boolean parseDate(int startIndex, int endIndex) {
        Date creationDate;
        if (this.curLine.charAt(startIndex) == '[' && this.curLine.charAt(endIndex) == ']' && (creationDate = this.SDFparser.parse(this.curLine.substring(startIndex + 1, endIndex).trim(), new ParsePosition(0))) != null) {
            this.currentTimeStamp = new StringBuffer(this.SDFformatter.format(creationDate).trim());
            this.currentTimeStamp.replace(10, 11, "T");
            this.currentTimeStamp.append(".000000");
            Calendar localCalendar = Calendar.getInstance();
            localCalendar.setTime(creationDate);
            int utcOffset = (localCalendar.get(15) + localCalendar.get(16)) / 60000;
            if (utcOffset < 0) {
                this.currentTimeStamp.append("-");
            } else {
                this.currentTimeStamp.append("+");
            }
            utcOffset = Math.abs(utcOffset);
            String numberHours = String.valueOf(utcOffset / 60);
            if (numberHours.length() == 1) {
                this.currentTimeStamp.append("0");
            }
            this.currentTimeStamp.append(numberHours);
            this.currentTimeStamp.append(":");
            String numberMinutes = String.valueOf(utcOffset % 60);
            if (numberMinutes.length() == 1) {
                this.currentTimeStamp.append("0");
            }
            this.currentTimeStamp.append(numberMinutes);
            return true;
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int previousIndex = 0;
        int currentIndex = this.curLine.indexOf("[", previousIndex);
        if (currentIndex == -1) {
            this.cgiDebuggingOutput.append(this.curLine);
            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
            this.cgiDebuggingOutput.append(this.curLine);
            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
            return false;
        }
        if (this.sensorFilterExitHelper.isCreationTimeFilterSet()) {
            this.currentTimeStamp = new StringBuffer(this.sensorFilterExitHelper.getCurrentEventCreationTime());
        } else if (!this.parseDate(previousIndex, currentIndex)) {
            this.cgiDebuggingOutput.append(this.curLine);
            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
            return false;
        }
        previousIndex = currentIndex;
        currentIndex = this.curLine.indexOf("[", previousIndex);
        if (currentIndex == -1) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
            return false;
        }
        this.category = this.curLine.substring(previousIndex + 1, currentIndex).trim();
        this.severity = this.sensorFilterExitHelper.isSeverityFilterSet() ? this.sensorFilterExitHelper.getCurrentEventSeverity() : (this.category.equals("emerg") || this.category.equals("alert") || this.category.equals("crit") || this.category.equals("error") ? (short)50 : (this.category.equals("warn") ? (short)30 : (short)10));
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("[client", previousIndex)) != -1) {
            previousIndex = currentIndex;
            if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
                return false;
            }
            this.clientIP = this.curLine.substring(previousIndex + 7, currentIndex).trim();
            previousIndex = currentIndex;
        }
        this.message = this.curLine.substring(previousIndex + 1).trim();
        currentIndex = this.curLine.indexOf(": ", previousIndex);
        if (currentIndex != -1) {
            this.fileName = this.curLine.substring(currentIndex + 2).trim();
        }
        return true;
    }

    protected void reset() {
        this.severity = 0;
        this.message = null;
        this.clientIP = null;
        this.fileName = null;
        this.cgiDebuggingOutput = new StringBuffer();
        this.category = null;
        this.currentTimeStamp = null;
    }
}

