/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.dijit-all");
dojo.require("dijit.Dialog");
dojo.require("dijit.TitlePane");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "utility");
org.eclipse.cosmos.provisional.dr.ps.components.utility.UIContext = function () {
	var _message = dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "utility");
	this.initialize = function(){
		var self = this;
		this.widgetStore = new org.eclipse.cosmos.provisional.dr.ps.components.data.WidgetStore({onInit:function(){
		 	dojo.publish("initializeWidget", [{context:self}]);	   
		}});
	},
	this.getStyleProperties = function(tag, onItem){		
		this.widgetStore.getWidgetProperties({tags:tag, onItem:onItem});
	},	
	this.createObject = function(prop, cell){       		
		//create widget		
		var properties = dojo.clone(prop);

		properties.UIContext = this;
		return eval("new "+properties.clazz+"(properties, cell)");
	
	},
	this.createWidgetView = function(tag, parentWidget, widgetCallback, cell, contextMap){
		var self = this;
   		this.getStyleProperties(tag, function(data){
   			var style = dojo.clone(data);
   			if ((style) && (style.view)){   				
   				
	   			style.view.parentWidget = parentWidget;
	   			
	   			var widgetProperties = style.view;
				widgetProperties.UIContext = self;
				widgetProperties.attachPoint = tag;
				widgetProperties.contextMap = contextMap;
				widgetProperties.dataMap = style.dataMap;
				var viewObject = dojo.getObject(widgetProperties.clazz);
				if (dojo.isFunction(viewObject)){
					//We need to see if this is a pure function or an object constructor...
					var widget = new viewObject(widgetProperties, cell);
				//call callback to with widget			
					if (widgetCallback)
						widgetCallback(widget);
					return true;
				}
			}
			return false;
   		});
		
	},	
	this.submitQuery=function(keyArgs){
		var item = keyArgs.item;
		var query = keyArgs.queryObject;
		var success = false;
		var log = true;
		if (keyArgs.log == false)
			log = keyArgs.log;
		if (typeof(query["queryHandler"]) != 'undefined'){
			//map input item to parameters of the query
			var postData = "";
				if (query.bindInput){
					success = query.bindInput(item, function(postData){
						//IE doesn't allow json object as post Data
						if (!(dojo.isString(postData)))
							postData = "";
						var deferred = dojo.rawXhrPost({
						        url: query["queryHandler"],
								handleAs: "json-comment-optional",
						        postData: postData,
						        render: query.render,        
						        onItem: keyArgs.onItem,
						        handle: function(response, ioArgs){
						                //This function handles the response.
						                //Inside this function, the "this" variable
						                //will be the object used as the argument to the dojo.xhrGet() call.
										if(response instanceof Error){
						                        if(response.dojoType == "cancel"){
						                                //The request was canceled by some other JavaScript code.						                        	   
						                        		if (log) cosmos.log.logInfo (dojo.string.substitute(this._message.REQUEST_CANCEL, [this.url, response]));
						                        }else if(response.dojoType == "timeout"){
						                                //The request took over 5 seconds to complete.
					                        		if (log) cosmos.log.logInfo (dojo.string.substitute(this._message.REQUEST_TIMEOUT, [this.url, response]));
						                        }else{
						                                //Some other error happened.
					                        		if (log) cosmos.log.logInfo (dojo.string.substitute(this._message.REQUEST_ERROR, [this.url, response]));
						                        }
						                }
										else if (response._error_){	
											//need to decode string messages
											var detail = unescape(response.detail);
											var message = unescape(response.message);
											rExp = /\+/gi;
											response.detail=detail.replace(rExp, " ");				
											response.message=message.replace(rExp, " ");
											cosmos.log.logError(response,true);					
											if(keyArgs.onError){
													var scope = keyArgs.scope ? keyArgs.scope : dojo.global;
													keyArgs.onError.call(scope, response);
											}
											 
										}
										else{				
						                	//should only store the record contents so that we don't load the full graph response when loading the record viewer
						                	//check to see if we have to transform the response before sending the data to the call back method
						                	if (typeof(render) != 'undefined'){
					                        	this.onItem(render(response));
				                        	}
						                	else{
					                        	this.onItem(response);
				                        	}
						                }
						                //If you think there could be other callback handlers registered with this deferred, then
						                //return response to propagate the same response to other callback handlers. Otherwise,
						                //the error callbacks may be called in the success case.
						                return response;
						        }
						});							
						
					
					});
				}
			}
		return success;
	},
 	dojo.subscribe("initialize", this, this.initialize);
 	return true;			
};




//This demonstrates a query unit   
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery",
	// superclass	
	null,
	{
		queryHandler: null,
		postData: "",
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){		
				callbackMethod(this.postData);
		},
		render: function(input){
			return input;
		}
	}
); 


//Tree node query unit   
dojo.declare(
"org.eclipse.cosmos.provisional.dr.ps.components.utility.TreeNodeQuery",
	// superclass	
	null,
	{
		queryHandler: null,
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){		
				callbackMethod("title="+data.title+"&epr="+data.epr);
		},
		render: function(input){
			return input;
		}
	}
); 


//Tree node property query unit   
dojo.declare(
"org.eclipse.cosmos.provisional.dr.ps.components.utility.TreeNodePropertyQuery",
	// superclass	
	null,
	{
		queryHandler: null,
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){
				callbackMethod("title="+data.title+"&epr="+data.epr+"&prop=true");
		},
		render: function(input){
			return input;
		}
	}
); 


//Tree node CMDBf   
dojo.declare(
"org.eclipse.cosmos.provisional.dr.ps.components.utility.TreeNodeCMDBf",
	// superclass	
	null,
	{
		queryHandler: null,
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){
			if (data.object != null){
				callbackMethod("title="+data.title+"&epr="+data.epr+"&object="+data.object);
			}
		},
		render: function(input){
			return input;
		}
	}
); 


dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorQuery",
			// superclass	
		   org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery,
			{
				queryHandler:"json?service=org/eclipse/cosmos/provisional/dr/drs/service/ErrorLogger",
				bindInput: function(data, callbackMethod){
			   		callbackMethod("message="+data.message+"&detail="+data.detail+"&sev="+data.severity);
				},
				render: function(input){
					return input;
				}
			}
		); 


dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog",
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
		 	title:"",
			message:"",	 	
			icon:"",
			detail:"",
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/ErrorDialog.html"),
			widgetsInTemplate: true,
			widgetId: "errorDialog",
			show: function(){
				this.dialogBox.show();
			},
			onOk: function(){
				this.dialogBox.onCancel();
			},
			submitQuery: function(){
			},
			postMixInProperties: function(){
				if (dojo.isObject(this.message)){
					if (this.message.title)
						this.title = this.message.title;
					if (this.message.detail)
						this.detail = this.message.detail;
					if (this.message.message)
						this.message = this.message.message;
				}
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog.superclass.postMixInProperties.apply(this, arguments);
			},
			postCreate: function(){
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog.superclass.postCreate.apply(this, arguments);			
				this.dialogBox = dijit.byId("dijit_Dialog_0");
			}
			
		}
	);   

org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler = function () {

 	this.serverHandler=null;
 	this.serverQuery=null;
 	this._context = null;
	//defines a url that will recieve logged messages.
 	this.ERROR=1;
 	this.INFO=2;
 	this.WARNING=4;
 	this.NONE=0;
	//atribute that determins if the message should be logged to the dojo debug console.
 	this.debug=7;
	//defines the dialog box that will show the message.
	this.promptDialog=null;
	//attribute that determines if a dialog box should be displayed when a message is logged
	this.prompt=0;
	this.persist=0;
	this.logError=function(message, prompt) {
	// summary: logs an error messages
	// description: the message is logged as an error message.  If the prompt argument
 	//    is set to true a dialog message is presented to the user.
		if (this.debug & this.ERROR)
			console.error(message);
		if ((prompt) || (this.promptDialog & this.ERROR)){
			this.dialog = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog({icon:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/images/error.gif"),title:"Error",message:message});
			this.dialog.show();
		}
		if (this.persist & this.ERROR){
			this.submitQuery(this.ERROR, message);
		}
	};
	this.logWarning=function(message, prompt) {
	// summary: logs a warning messages
	// description: the message is logged as a warning message.  If the prompt argument
 	//    is set to true a dialog message is presented to the user.
		if (this.debug & this.WARNING)
			console.debug(message);
		if ((prompt) || (this.promptDialog & this.WARNING)){
			this.dialog = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog({icon:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/images/warning.gif"),title:"Warning",message:message});
			this.dialog.show();
		}
		if (this.persist & this.WARNING){
			this.submitQuery(this.WARNING,message);
		}
	};
	this.logInfo=function(message, prompt) {
	// summary: logs an informational messages
	// description: the message is logged as an informational message.  If the prompt argument
 	//    is set to true a dialog message is presented to the user.
		if (this.debug & this.INFO)
			console.debug(message);
		if ((prompt) || (this.promptDialog & this.INFO)){
			this.dialog = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorDialog({icon:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.utility", "html/images/inform.gif"),title:"Information",message:message});
			this.dialog.show();
		}
		if (this.persist & this.INFO){
			this.submitQuery(this.INFO, message);
		}
	};
	this.submitQuery=function(severity, message, detail){
		if (this._context != null){
			if (this.serverQuery == null)
				this.serverQuery = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorQuery();
			if (this.serverHandler != null)
				this.serverQuery.queryHandler= this.serverHandler;
			this._context.submitQuery({queryObject:this.serverQuery, item:{message:message, detail:detail, severity:severity}, log:false, onItem:function(data){
				//do we need to log data received from data feed?
			}});
		}
	};
	return true;
};
var cosmos = new Object();

dojo.addOnLoad(
	function(e) {
		cosmos.log = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler();
		cosmos.context = new org.eclipse.cosmos.provisional.dr.ps.components.utility.UIContext();
		cosmos.log._context = cosmos.context;
		dojo.publish("initialize"); 
	}
);
