/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.query.QueryDialog",
	// superclass	
   org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery,
	{
		labelDialogQuery:"",
		builder:null,
		bindInput: function(data, callbackMethod){
			this.builder = new org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog({callback: callbackMethod, labelQuery:this.labelDialogQuery, title:this.title, epr:data.epr});
			this.builder.show();		
		},
		render: function(input){
			this.builder.destroy();
			this.builder = null;
			return input;
		}
	}
); 

 dojo.declare(
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog",
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
	 	rows:12,
	 	cols:80,
		labelQuery:"",	 	
		templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/Dialog.html"),
		widgetsInTemplate: true,
		widgetId: "queryDialog",
		show: function(){
			this.dialogBox.show();
		},
		onCancel: function(){
			this.dialogBox.onCancel();
		},
		submitQuery: function(){
			var query = "query="+document.getElementById(this.id+"_queryTextArea").value+"&epr="+this.epr;
			
			this.callback(query);
		},
		postMixInProperties: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog.superclass.postMixInProperties.apply(this, arguments);
		},
		postCreate: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog.superclass.postCreate.apply(this, arguments);
			var idLength = this.id.length;
			var index =  this.id.substring(idLength-2, idLength);
			this.dialogBox = dijit.byId("dijit_Dialog"+index);
		}
		
	}
);      