/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer");
dojo.require("dijit.layout.ContentPane");

 dojo.declare(
	'org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer',
	[dijit.layout.ContentPane], 
	{
		widgetClass:'cosmos:WidgetContainer',
		childWidget: null,
		oldWidget: null,
		UIContext:null,
		attachPoint: null,
		parseOnLoad:true,
		postCreate: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer.superclass.postCreate.apply(this, arguments);
		  	dojo.subscribe("initializeWidget", this, this.initWidget);				
			dojo.subscribe(this.attachPoint, this, this.updateContainer);
		},		
		resize: function(size){
			//for some reason the singleChild member variable does not get updated. Make sure we update the singleChild member variable 
			if (this._singleChild == null){
				this._checkIfSingleChild();
			}
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer.superclass.resize.apply(this, arguments);
		},		
		setChildWidget: function(widget){
				this.oldWidget = widget;		
		},
		updateContainer: function(message){
			this.destroyDescendants();
			if ((this.domNode.childNodes) && (this.domNode.childNodes.length>0)) {
				var nodeLength = this.domNode.childNodes.length;
				for (var x =0; x<nodeLength; x++)				
					this.domNode.removeChild(this.domNode.childNodes[0]);
			}
			if (this.oldWidget != null){
				this.oldWidget.destroy();
				this.oldWidget = null;
			}
		
	    	if (typeof(message.contextMap) != 'undefined'){
				resourceClass = message.contextMap.nodeClass;	
			}
		
	    	if (typeof(resourceClass) != 'undefined'){
				try{
					var styleProp = [this.attachPoint+" "+resourceClass,this.attachPoint];
					var self = this;							
					var div = document.createElement("div");
					this.domNode.appendChild(div);
					if ((styleProp)  && (typeof(styleProp) != 'undefined')){
						this.UIContext.context.createWidgetView(styleProp, this, function(widget){
							if (widget == null){
								self.destroyDescendants();
							}
						}, div,message.contextMap);
							
					}
				}catch(e){
					self.destroyDescendants();
					cosmos.log.logError(e);
				}
			}
	    },		
		initWidget: function(UIContext){
			if ((this.domNode.childNodes) && (this.domNode.childNodes.length>0)) {
				var nodeLength = this.domNode.childNodes.length;
				for (var x =0; x<nodeLength; x++)				
					this.domNode.removeChild(this.domNode.childNodes[0]);
			}
			if (this.oldWidget != null){
				this.oldWidget.destroy();
				this.oldWidget = null;
			}
			this.UIContext = UIContext;		
			if (this.attachPoint != null){
				try{
						var  div = document.createElement("div");
						var self = this;
						this.domNode.appendChild(div);
						this.UIContext.context.createWidgetView(this.attachPoint, this, function(widget){
								if (widget == null){
									self.destroyDescendants();
								}
							}, div, null);
					}catch(e){
						self.destroyDescendants();
						cosmos.log.logInfo(e);
					}						
			}
	    }
	    
	}
);
