/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.common");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.PropertiesContainer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Report");

dojo.declare(
		'org.eclipse.cosmos.provisional.dr.ps.components.widget.HTMLContainer',
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/HTMLContainer.html"),
			widgetId: "htmlcontainer",
			// width
			width : "100%",
			// height
			height : "400",
			content_provider: "",
			contentNode: null,
			postCreate: function(){
				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.widget.HTMLContainer.superclass.postCreate.apply(this, arguments);
				this.contentNode = document.getElementById(this.widgetId);
				this.resize();
				this.refreshContent(this.contextMap);
			},		
		    refreshContent:function(message) {
				var self = this;
				//make REST call to get content data
				if (typeof(this.contentQuery) != 'undefined'){
			    	var queryObject = this.UIContext.createObject(this.contentQuery);
					if (!(this.UIContext.submitQuery({queryObject:queryObject, item:message, onItem:function(response){
							self.changeit(response);						 												
							}, queryProp:"query"}))){					
					//reset page
						this.changeit(this.blankPath);
					}
				}
		    },
			changeit:function(url){
	  			this.contentNode.src=url;
			},
			resize:function(){
				if(!this.domNode.parentNode){
					return;
				}
				var h = dojo._getContentBox(this.domNode.parentNode).h;
				this.contentNode.style.height = (h-10) + 'px';

//				dojo.marginBox(this.domNode, { h: Math.max(0, h) });
			},
			// definitions
			blankPath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/blank.html")
		}
);

