/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.application.impl;

import java.util.ArrayList;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceProperty;
import org.eclipse.cosmos.rm.repository.internal.application.impl.AbstractSMLFragment;
import org.eclipse.cosmos.rm.repository.internal.reference.SMLQualifiedReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMLResourceProperty
extends AbstractSMLFragment
implements ISMLResourceProperty {
    private ISMLRepository repository;
    private Node root;
    private boolean reference;

    public static ISMLResourceProperty load(ISMLRepository repository, Node root) {
        if (root == null || root.getNodeType() != 1) {
            return null;
        }
        return new SMLResourceProperty(repository, root, "http://www.cosmos.rm/dataCenter/core".equals(root.getNamespaceURI()) && "propertyRef".equals(root.getLocalName()));
    }

    private SMLResourceProperty(ISMLRepository repository, Node root, boolean reference) {
        this.repository = repository;
        this.root = root;
        this.reference = reference;
    }

    public ISMLResourceProperty resolveReference() {
        if (!this.reference) {
            return this;
        }
        return SMLResourceProperty.load(this.repository, new SMLQualifiedReference(this.repository, SMLRepositoryUtil.extractReference(this.root)).resolveReference());
    }

    public boolean isReference() {
        return this.reference;
    }

    protected Node getRootNode() {
        return this.root;
    }

    public String[] retrieveAttributes() {
        NamedNodeMap attributes = this.root.getAttributes();
        if (attributes == null) {
            return new String[0];
        }
        int attributeCount = attributes.getLength();
        ArrayList<String> attributeList = new ArrayList<String>(attributeCount);
        int i = 0;
        while (i < attributeCount) {
            attributeList.add(attributes.item(i).getNodeName());
            ++i;
        }
        return attributeList.toArray(new String[attributeCount]);
    }

    public ISMLResourceProperty[] retrieveChildren() {
        NodeList children = this.root.getChildNodes();
        if (children == null) {
            return new ISMLResourceProperty[0];
        }
        int childCount = children.getLength();
        ArrayList<ISMLResourceProperty> properties = new ArrayList<ISMLResourceProperty>(childCount);
        int i = 0;
        while (i < childCount) {
            ISMLResourceProperty property;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (property = SMLResourceProperty.load(this.repository, node)) != null) {
                properties.add(property);
            }
            ++i;
        }
        return properties.toArray(new ISMLResourceProperty[properties.size()]);
    }

    public String retrievePropertyName() {
        return this.root.getLocalName();
    }

    public String retrieveValue(String attribute) {
        NamedNodeMap attributes = this.root.getAttributes();
        Node attributeNode = attributes == null ? null : attributes.getNamedItem(attribute);
        return attributeNode == null ? null : attributeNode.getNodeValue();
    }
}

