/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.AbstractSMLConstraintHandler;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;

public class ItemInstanceHandler
extends AbstractSMLConstraintHandler {
    public INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException {
        IInstanceIdConstraint instanceConstraint = (IInstanceIdConstraint)constraint;
        INodes result = QueryOutputArtifactFactory.getInstance().createNodes(context.getItemTemplate());
        IInstanceId[] instanceIds = instanceConstraint.getInstanceIds();
        int i = 0;
        while (i < instanceIds.length) {
            if ("http://cosmos.org/rm/sml/repository".equals(instanceIds[i].getMdrId().toString())) {
                try {
                    ISMLDocument[] returnedSet = this.getRepository().fetchDocuments(new SMLFileMetadata(instanceIds[i].getLocalId().toString(), -1, null, null, null));
                    if (returnedSet != null && returnedSet.length == 1) {
                        result.addItem((IItemConvertible)returnedSet[0]);
                    }
                }
                catch (RepositoryOperationException e) {
                    throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)e.getLocalizedMessage()), (Throwable)e);
                }
            }
            ++i;
        }
        return result;
    }
}

