/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPrefixMapping;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IXPathExpression;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.RepositoryMessages;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.AbstractSMLConstraintHandler;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.validation.internal.artifacts.MappedNamespaceContext;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.w3c.dom.Node;

public class ItemXPathHandler
extends AbstractSMLConstraintHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException {
        IXPathExpression xpathExpression = (IXPathExpression)constraint;
        if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(xpathExpression.getDialect().toString())) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)RepositoryMessages.errorUnsupportedXPathDialect));
        }
        try {
            INodes result = this.retrieveContext(context);
            IGraphElement[] elements = result.getElements();
            MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
            IPrefixMapping[] prefixMapping = xpathExpression.getPrefixMappings();
            int i = 0;
            while (i < prefixMapping.length) {
                namespaceContext.addEntry(prefixMapping[i].getPrefix(), prefixMapping[i].getNamespace().toString());
                ++i;
            }
            ISMLRepository repository = this.getRepository();
            ArrayList<IItem> revisedList = new ArrayList<IItem>();
            int i2 = 0;
            while (i2 < elements.length) {
                block18: {
                    XPath xPath = SMLValidatorUtil.xpath;
                    synchronized (xPath) {
                        SMLValidatorUtil.xpath.setNamespaceContext((NamespaceContext)namespaceContext);
                        XPathExpression fieldXPath = SMLValidatorUtil.xpath.compile(xpathExpression.getExpression());
                        IItem item = (IItem)elements[i2];
                        Node rootNode = CMDBfUtil.retrieveDocumentNode(repository, item);
                        if (rootNode == null) {
                            break block18;
                        }
                        String xpathResult = fieldXPath.evaluate(rootNode);
                        Node xpathNodeResult = null;
                        if (xpathResult == null || xpathResult.length() <= 0 || "false".equals(xpathResult)) {
                            if (!"false".equals(xpathResult)) {
                                xpathNodeResult = (Node)fieldXPath.evaluate(rootNode, XPathConstants.NODE);
                            }
                            if (xpathNodeResult == null) {
                                break block18;
                            }
                        } else if (!"true".equals(xpathResult)) {
                            xpathNodeResult = (Node)fieldXPath.evaluate(rootNode, XPathConstants.NODE);
                        }
                        IRecord record = item.getRecords()[0];
                        if (context.isStartingContext()) {
                            record.setValue((IXMLWritable)new CMDBfInternalUtility.NodeXMLWritable(xpathNodeResult));
                        } else if (record.getValue() instanceof CMDBfInternalUtility.NodeXMLWritable) {
                            CMDBfInternalUtility.NodeXMLWritable nodeWritable = (CMDBfInternalUtility.NodeXMLWritable)record.getValue();
                            nodeWritable.addNode(xpathNodeResult);
                        }
                        revisedList.add(item);
                    }
                }
                ++i2;
            }
            result.setElements(revisedList.toArray(new IGraphElement[revisedList.size()]));
            return result;
        }
        catch (XPathExpressionException e) {
            throw new CMDBfServiceException(0, 2, CMDBfMessages.faultsQueryXPathError, new Node[]{CMDBfInternalUtility.appendNode((Node)CMDBfInternalUtility.createElement((String)"http://cmdbf.org/schema/1-0-0/datamodel", (String)"cmdbf:expression"), (Node)CMDBfInternalUtility.createTextNode((String)xpathExpression.getExpression())), CMDBfInternalUtility.appendNode((Node)CMDBfInternalUtility.createElement((String)"http://cmdbf.org/schema/1-0-0/datamodel", (String)"cmdbf:xpathErrorCode"), (Node)CMDBfInternalUtility.createTextNode((String)e.getMessage()))}, (Throwable)e);
        }
        catch (RepositoryOperationException e) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)e.getMessage()), (Throwable)e);
        }
    }
}

