/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IRelationship;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IRelationshipConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.RepositoryMessages;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTemplateHandler
extends AbstractQueryHandler
implements IRelationshipTemplateHandler {
    public void initialize(Map<String, Object> init) throws CMDBfServiceException {
        if (!(init.get("org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.DATA_PROVIDER") instanceof ISMLRepository)) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)RepositoryMessages.errorBadInitData));
        }
        super.initialize(init);
    }

    public IEdges execute(IQueryResult result, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws CMDBfServiceException {
        IEdges edges = QueryOutputArtifactFactory.getInstance().createEdges(relationshipTemplate);
        try {
            ISMLDocument[] references;
            ISMLRepository repository = (ISMLRepository)this.getValue("org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.DATA_PROVIDER");
            SMLFileInstanceDocument sourceDocument = CMDBfUtil.retrieveDocument(repository, source);
            SMLFileInstanceDocument targetDocument = CMDBfUtil.retrieveDocument(repository, target);
            if (sourceDocument != null && targetDocument != null && (references = sourceDocument.retrieveReferences(targetDocument.getMetadata())) != null && references.length > 0) {
                IRelationship relationship = QueryOutputArtifactFactory.getInstance().createRelationship();
                relationship.setSourceId(QueryOutputArtifactFactory.getInstance().createInstanceId("http://cosmos.org/rm/sml/repository", sourceDocument.getMetadata().getId()));
                relationship.setTargetId(QueryOutputArtifactFactory.getInstance().createInstanceId("http://cosmos.org/rm/sml/repository", targetDocument.getMetadata().getId()));
                edges.addRelationship((IRelationshipConvertible)relationship);
            }
        }
        catch (RepositoryOperationException e) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)e.getMessage()));
        }
        return edges;
    }
}

