/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceExtractor
extends AbstractDataBuilder<List<ReferenceDescriptor>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ReferenceExtractor";
    private boolean uriElementHit;
    private StringBuffer currentReference = new StringBuffer();
    private List<ReferenceDescriptor> references = new ArrayList<ReferenceDescriptor>();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("http://schemas.serviceml.org/sml/2007/02".equals(uri) && "uri".equals(localName)) {
            this.uriElementHit = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("http://schemas.serviceml.org/sml/2007/02".equals(uri) && "uri".equals(localName)) {
            this.uriElementHit = false;
            this.references.add(new ReferenceDescriptor(this.getFilePath(), this.locator.getLineNumber(), this.currentReference.toString()));
            this.currentReference = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.uriElementHit) {
            String string = new String(ch, start, length);
            if (this.currentReference.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.currentReference.append(' ');
            }
            this.currentReference.append(string.trim());
        }
    }

    @Override
    public List<ReferenceDescriptor> getDataStructure() {
        return this.references;
    }
}

