/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mdr.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.dataManager.impl.AbstractDataManager;
import org.eclipse.cosmos.dc.mdr.api.IMdrAdmin;
import org.eclipse.cosmos.dc.mdr.api.IMdrQuery;
import org.eclipse.cosmos.dc.mdr.exception.CMDBfException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMdr
extends AbstractDataManager
implements IMdrQuery,
IMdrAdmin {
    private CMDBfQueryOperation queryOp = new CMDBfQueryOperation(this.getQueryHandlerFactory(), null);

    public abstract IQueryHandlerFactory getQueryHandlerFactory();

    protected CMDBfQueryOperation getQueryOperation() {
        return this.queryOp;
    }

    public Element query(Element queryRequest) throws CMDBfException {
        System.out.println("#### Executing MDR query ####");
        InputStream inputStream = null;
        try {
            inputStream = this.toInputStream(queryRequest);
        }
        catch (Exception exception) {
            throw new CMDBfException("Failed to create input stream from query input.");
        }
        try {
            IQueryResult result = this.queryOp.execute(inputStream);
            InputStream output = QueryOutputTransformer.transform((IQueryResult)result);
            Document doc = null;
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(output);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new CMDBfException("Error in transforming query output to XML element", (Throwable)e);
        }
    }

    private InputStream toInputStream(Element queryRequest) throws Exception {
        Node queryNode = null;
        StringWriter sw = null;
        NodeList nodelist = queryRequest.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node next = nodelist.item(i);
            if (next.getNodeType() == 1 && next.getLocalName().equals("query")) {
                queryNode = next;
                break;
            }
            ++i;
        }
        if (queryNode == null) {
            throw new DataManagerException("Missing query element in query request");
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        sw = new StringWriter();
        trans.transform(new DOMSource(queryNode), new StreamResult(sw));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
        return inputStream;
    }
}

