/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.query.service.impl;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractItemTemplateHandler
extends AbstractQueryHandler
implements IItemTemplateHandler {
    public INodes execute(IItemTemplate itemTemplate) throws CMDBfServiceException {
        if (!this.isInitialized()) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)NLS.bind((String)CMDBfMessages.faultsCommonUninitialized, (Object)this.getClass().getName())));
        }
        INodes nodes = this.getQueryOutputArtifactFactory().createNodes(itemTemplate);
        if (itemTemplate.getInstanceIdConstraint() != null || itemTemplate.getRecordConstraints() != null && itemTemplate.getRecordConstraints().length > 0 || itemTemplate.getXpathExpressions() != null && itemTemplate.getXpathExpressions().length > 0) {
            nodes.setStartingContext(true);
        } else {
            this.appendAllItems(nodes);
        }
        return nodes;
    }

    protected IQueryOutputArtifactFactory getQueryOutputArtifactFactory() {
        return QueryOutputArtifactFactory.getInstance();
    }

    protected abstract void appendAllItems(INodes var1) throws CMDBfServiceException;
}

