/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import java.io.StringWriter;
import java.net.URI;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IAdditionalRecordType;

public class AdditionalRecordType
implements IAdditionalRecordType,
IXMLWritable {
    private URI namespace;
    private String localName;

    public AdditionalRecordType(String namespace, String localName) {
        this.setNamespace(namespace);
        this.setLocalName(localName);
    }

    public AdditionalRecordType() {
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespaceString) {
        this.setNamespace(CMDBfServicesUtil.createURI(namespaceString));
    }

    public void setNamespace(URI namespace) {
        this.namespace = namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write("<additionalRecordType ");
        CMDBfServicesUtil.writeAttribute(writer, "namespace", this.getNamespace().toString());
        writer.write(ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.addIndent(writer, indent + 2);
        CMDBfServicesUtil.writeAttribute(writer, "localName", this.getLocalName());
        writer.write("/>" + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdditionalRecordType other = (AdditionalRecordType)obj;
        if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }
}

