/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.util.BasicFilterExit;
import org.eclipse.hyades.logging.adapter.util.BufferedPeriodicReader;
import org.eclipse.hyades.logging.adapter.util.BufferedSinglePassReader;
import org.eclipse.hyades.logging.adapter.util.FilterExitLoaderUtil;
import org.eclipse.hyades.logging.adapter.util.InvalidFilterSpecification;
import org.eclipse.hyades.logging.adapter.util.MultipleFilesReader;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class MonitoringParser
extends Parser {
    private BufferedPeriodicReader input = null;
    private boolean endOfFile = true;
    private boolean multi = false;
    private RandomAccessFile tmpLog = null;

    public void setConfiguration(Hashtable table) throws LogParserException {
        this.file_path = null;
        try {
            this.tmpFile = File.createTempFile(prefix, null);
            this.tmpLog = new RandomAccessFile(this.tmpFile, "rws");
        }
        catch (Exception exception) {
            this.tmpLog = null;
        }
        this.logFile = null;
        try {
            Integer array_size;
            block41: {
                this.file_path = (String)table.get("file_path");
                if (this.file_path != null) {
                    String dirPath = (String)table.get("directory");
                    String fName = (String)table.get("fileName");
                    if (fName != null && fName.length() > 0 && dirPath != null && dirPath.length() > 0) {
                        dirPath = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? dirPath.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : dirPath.replace('/', ParserConstants.FILE_SEPARATOR_CHARACTER);
                    } else {
                        this.file_path = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? this.file_path.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : this.file_path.replace('/', ParserConstants.FILE_SEPARATOR_CHARACTER);
                        fName = this.file_path.substring(this.file_path.lastIndexOf(ParserConstants.FILE_SEPARATOR_CHARACTER) + 1);
                        dirPath = this.file_path.substring(0, this.file_path.indexOf(fName) - 1);
                    }
                    if (fName == null || dirPath == null) {
                        throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                    }
                    boolean continuousContext = (Boolean)table.get("continuous");
                    File dir = new File(dirPath);
                    if (!dir.exists() || !dir.isDirectory()) {
                        throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                    }
                    this.mfr = new MultipleFilesReader(dirPath, fName, this.tmpLog);
                    this.mfr.init();
                    if (this.mfr.size() <= 1) {
                        this.multi = false;
                        if (this.tmpLog != null) {
                            try {
                                this.tmpLog.close();
                            }
                            catch (IOException iOException) {}
                            this.tmpLog = null;
                        }
                        if (this.mfr.size() == 1) {
                            this.file_path = this.mfr.getNext();
                        } else if (!continuousContext) {
                            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                        }
                    } else {
                        this.multi = true;
                        this.file_path = this.tmpFile.getAbsolutePath();
                        if (continuousContext) {
                            this.mfr.start();
                        } else {
                            this.mfr.loadConsolidatedFile();
                        }
                    }
                    if (!continuousContext) {
                        File file = new File(this.file_path);
                        if (!file.isFile()) {
                            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                        }
                        if (!file.canRead()) {
                            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_CANNOT_READ_FILE_ERROR_", this.file_path));
                        }
                    }
                    this.input = continuousContext ? new BufferedPeriodicReader(this.file_path) : new BufferedSinglePassReader(this.file_path);
                    Integer confBufSize = (Integer)table.get("confidence_buffer_size");
                    Integer fileFooterSize = (Integer)table.get("file_footer_size");
                    this.charset = (String)table.get("characater_set");
                    this.fileLocale = (Locale)table.get("locale");
                    if (table.containsKey("enableICU")) {
                        this.enableICU = (Boolean)table.get("enableICU");
                        if (this.enableICU) {
                            this.fileULocale = (ULocale)table.get("ULocale");
                        }
                    }
                    if (this.charset != null) {
                        this.input.setCharset(this.charset);
                    }
                    if (confBufSize != null) {
                        this.input.setConfidenceBufferSize(confBufSize.intValue());
                    }
                    if (fileFooterSize != null) {
                        this.input.setFileFooterSize(fileFooterSize.intValue());
                    }
                    this.input.setMultiFile(this.multi);
                }
                this.filter = (String)table.get("filter");
                this.filterExitClass = (String)table.get("filterExitClass");
                if (this.filter != null) {
                    this.filter = this.filter.trim();
                    if (this.filter.length() == 0) {
                        this.filter = null;
                    }
                }
                if (this.filterExitClass != null) {
                    this.filterExitClass = this.filterExitClass.trim();
                    if (this.filterExitClass.length() == 0) {
                        this.filterExitClass = null;
                    }
                }
                if (this.filterExitClass != null && !this.filterExitClass.equals("")) {
                    try {
                        this.filterExitClassInstance = FilterExitLoaderUtil.instantiate((String)this.filterExitClass);
                        if (this.filter == null || this.filter.equals("")) break block41;
                        try {
                            this.filterExitClassInstance.setFilterSpecification(this.filter);
                            break block41;
                        }
                        catch (InvalidFilterSpecification ex) {
                            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILTER_SPECIFICATION_ERROR_", this.filter), ex);
                        }
                    }
                    catch (Exception exception) {
                        throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_LOAD_FILTEREXIT_CLASS_ERROR_", this.filterExitClass));
                    }
                }
                if (this.filter != null && !this.filter.equals("")) {
                    this.filterExitClassInstance = new BasicFilterExit();
                    try {
                        this.filterExitClassInstance.setFilterSpecification(this.filter);
                    }
                    catch (InvalidFilterSpecification ex) {
                        throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILTER_SPECIFICATION_ERROR_", this.filter), ex);
                    }
                }
            }
            if ((array_size = (Integer)table.get("array_size")) != null) {
                this.MessageArraySize = array_size;
            }
            this.messages = new CommonBaseEvent[this.MessageArraySize];
            int i = 0;
            while (i < this.MessageArraySize) {
                this.messages[i] = eventFactory.createCommonBaseEvent();
                ++i;
            }
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
        }
    }

    public void postParse() throws LogParserException {
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
            this.mfr.interrupt();
            if (this.tmpLog != null) {
                try {
                    this.tmpLog.close();
                    this.tmpLog = null;
                }
                catch (IOException iOException) {}
            }
            this.tmpFile.delete();
        }
        catch (Exception e) {
            ParserUtilities.exceptionHandler(e, "");
        }
    }

    protected String readALine() throws LogParserException {
        String msgLine = null;
        if (this.endOfFile) {
            try {
                this.input.prepare();
                this.endOfFile = false;
                this.totalSize = this.input.getSize();
            }
            catch (Exception e) {
                throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_CANNOT_READ_FILE_ERROR_", this.file_path), e);
            }
        }
        try {
            this.input.setFlushingMode(this.flushingMode);
            msgLine = this.input.readLine();
            if (msgLine != null) {
                this.processedSize += (long)msgLine.length();
                ++this.curLineNumber;
            }
        }
        catch (IOException i) {
            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_CANNOT_READ_FILE_ERROR_", this.file_path), i);
        }
        return msgLine;
    }

    protected String readLine() {
        try {
            return this.readALine();
        }
        catch (LogParserException logParserException) {
            return null;
        }
    }

    protected void setFilename(String newfile) throws LogParserException {
        if (this.input == null) {
            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_NOT_CONFIGURED_ERROR_"));
        }
        this.input.setFilename(newfile);
    }

    protected void setConverterCommand(String converterCmd) throws LogParserException {
        if (this.input == null) {
            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_NOT_CONFIGURED_ERROR_"));
        }
        this.input.setConverter(converterCmd);
    }

    protected void setConverterCommand(String[] converterCmd) throws LogParserException {
        if (this.input == null) {
            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_NOT_CONFIGURED_ERROR_"));
        }
        this.input.setConverter(converterCmd);
    }

    protected long getFilePointer() {
        if (this.input != null) {
            return this.input.getFilePointer();
        }
        return 0L;
    }

    protected void setEndOfFile() {
        this.endOfFile = true;
    }

    public boolean isEndOfFile() {
        return this.endOfFile;
    }
}

