/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IExtractor;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.util.BasicFilterExit;
import org.eclipse.hyades.logging.adapter.util.FilterExitLoaderUtil;
import org.eclipse.hyades.logging.adapter.util.IFilterExit;
import org.eclipse.hyades.logging.adapter.util.ITimeFilterExit;
import org.eclipse.hyades.logging.adapter.util.InvalidFilterSpecification;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;

public abstract class Extractor
extends ProcessUnit
implements IExtractor {
    private boolean nestedMessages = false;
    private boolean containsLineBreaks = false;
    private boolean replaceLineBreaks = false;
    private String lineBreakSymbol = null;
    private String startPattern = null;
    private boolean includeStartPattern = false;
    private String endPattern = null;
    private boolean includeEndPattern = false;
    private String childStartPattern = null;
    private boolean includeChildStartPattern = false;
    private String childEndPattern = null;
    private boolean includeChildEndPattern = false;
    private String filter = null;
    private String filterExitClass = null;
    private IFilterExit filterExitClassInstance = null;

    public void setNestedMessages(boolean nestedMessages) {
        this.nestedMessages = nestedMessages;
    }

    public boolean isNestedMessages() {
        return this.nestedMessages;
    }

    public Object[] processEventItems(Object[] msgs) {
        return this.processStrings((String[])msgs);
    }

    public abstract MessageString[] processStrings(String[] var1);

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof String[])) {
            throw new AdapterInvalidConfig("This extractor will only accept arrays of String");
        }
        return this.testProcessStrings((String[])msgs);
    }

    public MessageString[] testProcessStrings(String[] events) {
        return new MessageString[2];
    }

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        Hashtable sensorProperties;
        super.update();
        Element element = this.getConfiguration();
        if (element != null) {
            if (element.hasAttribute("lineBreakSymbol")) {
                this.setLineBreakSymbol(element.getAttribute("lineBreakSymbol"));
            }
            if (element.hasAttribute("containsLineBreaks")) {
                this.setContainsLineBreaks(Boolean.valueOf(element.getAttribute("containsLineBreaks")));
            }
            if (element.hasAttribute("replaceLineBreaks")) {
                this.setReplaceLineBreaks(Boolean.valueOf(element.getAttribute("replaceLineBreaks")));
            }
            if (element.hasAttribute("description")) {
                this.setDescription(element.getAttribute("description"));
            }
            if (element.hasAttribute("startPattern")) {
                this.setStartPattern(element.getAttribute("startPattern"));
            }
            if (element.hasAttribute("endPattern")) {
                this.setEndPattern(element.getAttribute("endPattern"));
            }
            if (element.hasAttribute("includeStartPattern")) {
                this.setIncludeStartPattern(Boolean.valueOf(element.getAttribute("includeStartPattern")));
            }
            if (element.hasAttribute("includeEndPattern")) {
                this.setIncludeEndPattern(Boolean.valueOf(element.getAttribute("includeEndPattern")));
            }
        }
        if ((sensorProperties = this.getProperties()) != null && !sensorProperties.isEmpty()) {
            block26: {
                this.filter = (String)sensorProperties.get("filter");
                this.filterExitClass = (String)sensorProperties.get("filterExitClass");
                if (this.filter != null) {
                    this.filter = this.filter.trim();
                    if (this.filter.length() == 0) {
                        this.filter = null;
                    }
                }
                if (this.filterExitClass != null) {
                    this.filterExitClass = this.filterExitClass.trim();
                    if (this.filterExitClass.length() == 0) {
                        this.filterExitClass = null;
                    }
                }
                if (this.filterExitClass != null && !this.filterExitClass.equals("")) {
                    try {
                        this.filterExitClassInstance = FilterExitLoaderUtil.instantiate(this.filterExitClass);
                        if (this.filter == null || this.filter.equals("")) break block26;
                        try {
                            this.filterExitClassInstance.setFilterSpecification(this.filter);
                            break block26;
                        }
                        catch (InvalidFilterSpecification ex) {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_FilterExit_Invalid_FilterSpecification_ERROR_", this.filter), ex);
                        }
                    }
                    catch (AdapterInvalidConfig aicex) {
                        throw aicex;
                    }
                    catch (Exception exception) {
                        throw new AdapterInvalidConfig(Messages.getString("HyadesGA_FilterExit_GetFilterExit_Failure_ERROR_", this.filterExitClass));
                    }
                }
                if (this.filter != null && !this.filter.equals("")) {
                    this.filterExitClassInstance = new BasicFilterExit();
                    try {
                        this.filterExitClassInstance.setFilterSpecification(this.filter);
                    }
                    catch (InvalidFilterSpecification ex) {
                        throw new AdapterInvalidConfig(Messages.getString("HyadesGA_FilterExit_Invalid_FilterSpecification_ERROR_", this.filter), ex);
                    }
                }
            }
            if (this.filterExitClassInstance != null && this.filterExitClassInstance instanceof ITimeFilterExit) {
                ITimeFilterExit exit = (ITimeFilterExit)this.filterExitClassInstance;
                IComponent current = this;
                while (current != null) {
                    if (current instanceof Context) {
                        Context context = (Context)current;
                        exit.setDay(context.getDay());
                        exit.setMonth(context.getMonth());
                        exit.setYear(context.getYear());
                        exit.setTimezone(context.getTimezone());
                        exit.setLocale(context.getLocale());
                        exit.setULocale(context.getULocale());
                        break;
                    }
                    current = current.getParent();
                }
            }
        }
    }

    public void setContainsLineBreaks(boolean containsLineBreaks) {
        this.containsLineBreaks = containsLineBreaks;
        this.updateConfigurationAttribute("containsLineBreaks", containsLineBreaks ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public boolean getContainsLineBreaks() {
        return this.containsLineBreaks;
    }

    public void setReplaceLineBreaks(boolean replaceLineBreaks) {
        this.replaceLineBreaks = replaceLineBreaks;
        this.updateConfigurationAttribute("replaceLineBreaks", replaceLineBreaks ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public boolean getReplaceLineBreaks() {
        return this.replaceLineBreaks;
    }

    public void setLineBreakSymbol(String newLineBreakSymbol) {
        this.lineBreakSymbol = newLineBreakSymbol;
        this.updateConfigurationAttribute("lineBreakSymbol", newLineBreakSymbol);
    }

    public String getLineBreakSymbol() {
        return this.lineBreakSymbol;
    }

    public void setStartPattern(String startPattern) {
        this.startPattern = startPattern;
        this.updateConfigurationAttribute("startPattern", startPattern);
    }

    public String getStartPattern() {
        return this.startPattern;
    }

    public void setIncludeStartPattern(boolean includeStartPattern) {
        this.includeStartPattern = includeStartPattern;
        this.updateConfigurationAttribute("includeStartPattern", includeStartPattern ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public boolean getIncludeStartPattern() {
        return this.includeStartPattern;
    }

    public void setEndPattern(String endPattern) {
        this.endPattern = endPattern;
        this.updateConfigurationAttribute("endPattern", endPattern);
    }

    public String getEndPattern() {
        return this.endPattern;
    }

    public void setIncludeEndPattern(boolean includeEndPattern) {
        this.includeEndPattern = includeEndPattern;
        this.updateConfigurationAttribute("includeEndPattern", includeEndPattern ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public boolean getIncludeEndPattern() {
        return this.includeEndPattern;
    }

    public void setChildStartPattern(String childStartPattern) {
        this.childStartPattern = childStartPattern;
    }

    public String getChildStartPattern() {
        return this.childStartPattern;
    }

    public void setIncludeChildStartPattern(boolean includeChildStartPattern) {
        this.includeChildStartPattern = includeChildStartPattern;
    }

    public boolean getIncludeChildStartPattern() {
        return this.includeChildStartPattern;
    }

    public void setChildEndPattern(String childEndPattern) {
        this.childEndPattern = childEndPattern;
    }

    public String getChildEndPattern() {
        return this.childEndPattern;
    }

    public void setIncludeChildEndPattern(boolean includeChildEndPattern) {
        this.includeChildEndPattern = includeChildEndPattern;
    }

    public boolean getIncludeChildEndPattern() {
        return this.includeChildEndPattern;
    }

    public IFilterExit getFilterExitClassInstance() {
        return this.filterExitClassInstance;
    }
}

