/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cosmos.dc.mgmt.annotations.CreateManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.DestroyManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEvent;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedProperty;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagementProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProxyInvocationHandler
implements InvocationHandler {
    private HashMap<Method, Annotation[]> eventMethods = new HashMap();
    private HashMap<Method, Annotation[]> getterMethods = new HashMap();
    private HashMap<Method, Annotation[]> setterMethods = new HashMap();
    private HashMap<Method, Annotation[]> addMethods = new HashMap();
    private HashMap<Method, Annotation[]> removeMethods = new HashMap();
    private HashMap<Method, Method> interceptedMethods = new HashMap();
    private static ContributionManager manager;
    private static final Field[] EMPTY_FIELD_ARRAY;
    private Object wrappedObject;
    private static Method getProxiedClassMethod;
    private static Method getProxiedObjectMethod;
    private static Method getProxiedMethodMethod;

    static {
        EMPTY_FIELD_ARRAY = new Field[0];
        try {
            getProxiedClassMethod = ManagementProxy.class.getMethod("getProxiedClass", new Class[0]);
            getProxiedObjectMethod = ManagementProxy.class.getMethod("getProxiedObject", new Class[0]);
            getProxiedMethodMethod = ManagementProxy.class.getMethod("getProxiedMethod", Method.class);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public static void setManager(ContributionManager mgr) {
        manager = mgr;
    }

    private static void extractFields(Class clazz, HashMap<String, Field> map) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (map.get(field.getName()) == null) {
                map.put(field.getName(), field);
            }
            ++n2;
        }
    }

    private boolean equivelentMethod(Method iMethod, Method mMethod) {
        Class<?>[] mParms;
        Class<?>[] iParms;
        boolean ok = true;
        if (!iMethod.getName().equals(mMethod.getName())) {
            return false;
        }
        if (iMethod.getReturnType().equals(mMethod.getReturnType()) && (iParms = iMethod.getParameterTypes()).length == (mParms = mMethod.getParameterTypes()).length) {
            int i = 0;
            Class<?>[] classArray = iParms;
            int n = iParms.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> pClass = classArray[n2];
                if (!pClass.equals(mParms[i++])) {
                    ok = false;
                    break;
                }
                ++n2;
            }
        }
        return ok;
    }

    private void getDuplicateMethods() {
        ArrayList methodList;
        Class<?>[] interfaces = this.wrappedObject.getClass().getInterfaces();
        new HashMap();
        HashMap<String, ArrayList<Method>> interfaceMethods = new HashMap<String, ArrayList<Method>>();
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Class<?> interfaze = classArray[n2];
            Method[] methodArray = methods = interfaze.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                ArrayList<Method> methodList2 = null;
                methodList2 = (ArrayList<Method>)interfaceMethods.get(method.getName());
                if (methodList2 == null) {
                    methodList2 = new ArrayList<Method>();
                    interfaceMethods.put(method.getName(), methodList2);
                }
                methodList2.add(method);
                ++n4;
            }
            ++n2;
        }
        HashMap<Method, Method> dupMethods = new HashMap<Method, Method>();
        for (Method method : this.addMethods.keySet()) {
            methodList = null;
            methodList = (ArrayList)interfaceMethods.get(method.getName());
            if (methodList == null) continue;
            for (Method iMethod : methodList) {
                if (!this.equivelentMethod(iMethod, method)) continue;
                dupMethods.put(iMethod, method);
            }
        }
        if (!dupMethods.isEmpty()) {
            for (Method iMethod : dupMethods.keySet()) {
                this.addMethods.put(iMethod, this.addMethods.get(dupMethods.get(iMethod)));
                this.interceptedMethods.put(iMethod, iMethod);
            }
        }
        dupMethods.clear();
        for (Method method : this.removeMethods.keySet()) {
            methodList = null;
            methodList = (ArrayList)interfaceMethods.get(method.getName());
            if (methodList == null) continue;
            for (Method iMethod : methodList) {
                if (!this.equivelentMethod(iMethod, method)) continue;
                dupMethods.put(iMethod, method);
            }
        }
        if (!dupMethods.isEmpty()) {
            for (Method iMethod : dupMethods.keySet()) {
                this.removeMethods.put(iMethod, this.removeMethods.get(dupMethods.get(iMethod)));
                this.interceptedMethods.put(iMethod, iMethod);
            }
        }
        dupMethods.clear();
        for (Method method : this.getterMethods.keySet()) {
            methodList = null;
            methodList = (ArrayList)interfaceMethods.get(method.getName());
            if (methodList == null) continue;
            for (Method iMethod : methodList) {
                if (!this.equivelentMethod(iMethod, method)) continue;
                dupMethods.put(iMethod, method);
            }
        }
        if (!dupMethods.isEmpty()) {
            for (Method iMethod : dupMethods.keySet()) {
                this.getterMethods.put(iMethod, this.getterMethods.get(dupMethods.get(iMethod)));
                this.interceptedMethods.put(iMethod, iMethod);
            }
        }
        dupMethods.clear();
        for (Method method : this.setterMethods.keySet()) {
            methodList = null;
            methodList = (ArrayList)interfaceMethods.get(method.getName());
            if (methodList == null) continue;
            for (Method iMethod : methodList) {
                if (!this.equivelentMethod(iMethod, method)) continue;
                dupMethods.put(iMethod, method);
            }
        }
        if (!dupMethods.isEmpty()) {
            for (Method iMethod : dupMethods.keySet()) {
                this.setterMethods.put(iMethod, this.setterMethods.get(dupMethods.get(iMethod)));
                this.interceptedMethods.put(iMethod, iMethod);
            }
        }
        dupMethods.clear();
        for (Method method : this.eventMethods.keySet()) {
            methodList = null;
            methodList = (ArrayList)interfaceMethods.get(method.getName());
            if (methodList == null) continue;
            for (Method iMethod : methodList) {
                if (!this.equivelentMethod(iMethod, method)) continue;
                dupMethods.put(iMethod, method);
            }
        }
        if (!dupMethods.isEmpty()) {
            for (Method iMethod : dupMethods.keySet()) {
                this.eventMethods.put(iMethod, this.eventMethods.get(dupMethods.get(iMethod)));
                this.interceptedMethods.put(iMethod, iMethod);
            }
        }
    }

    private static Method[] getBeanMethods(ManagedProperty prop, Field field, Class resourceClass) {
        String name = field.getName();
        name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        String getterName = "get" + name;
        String setterName = "set" + name;
        Class[] setterParm = new Class[]{field.getType()};
        Class[] getterParm = new Class[]{};
        Method getterMethod = null;
        Method setterMethod = null;
        try {
            getterMethod = resourceClass.getMethod(getterName, getterParm);
            if (!getterMethod.getReturnType().equals(field.getType())) {
                getterMethod = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            getterName = "is" + name;
            try {
                getterMethod = resourceClass.getMethod(getterName, getterParm);
                if (!getterMethod.getReturnType().equals(field.getType())) {
                    getterMethod = null;
                }
            }
            catch (SecurityException securityException) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        try {
            setterMethod = resourceClass.getMethod(setterName, setterParm);
            if (!setterMethod.getReturnType().equals(Void.TYPE)) {
                setterMethod = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return new Method[]{getterMethod, setterMethod};
    }

    private static Method[] getRelationMethods(ManagedRelation relation, Field field, Class resourceClass) {
        String name = field.getName();
        String addName = relation.addName();
        String removeName = relation.removeName();
        if ("".equals(addName) || "".equals(removeName)) {
            name = "".equals(relation.name()) ? field.getName() : relation.name();
            name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
            if ("".equals(addName)) {
                addName = "add" + name;
            }
            if ("".equals(removeName)) {
                removeName = "remove" + name;
            }
        }
        Class<?> parmType = field.getType();
        if (!"".equals(relation.relatedClassName())) {
            try {
                parmType = resourceClass.getClassLoader().loadClass(relation.relatedClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        Class[] addParm = new Class[]{parmType};
        Class[] removeParm = new Class[]{parmType};
        Method addMethod = null;
        Method removeMethod = null;
        try {
            addMethod = resourceClass.getMethod(addName, addParm);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            removeMethod = resourceClass.getMethod(removeName, removeParm);
            if (!removeMethod.getReturnType().equals(Void.TYPE)) {
                removeMethod = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return new Method[]{addMethod, removeMethod};
    }

    private void processAnnotations() {
        Method[] methods;
        Field[] fields;
        Class<?> resourceClass = this.wrappedObject.getClass();
        HashMap<String, Field> map = new HashMap<String, Field>();
        Class<?> workingClass = resourceClass;
        while (workingClass != Object.class) {
            ManagedProxyInvocationHandler.extractFields(workingClass, map);
            workingClass = workingClass.getSuperclass();
        }
        Field[] fieldArray = fields = map.values().toArray(EMPTY_FIELD_ARRAY);
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annotations;
            Field field = fieldArray[n2];
            ManagedRelation relation_annotation = field.getAnnotation(ManagedRelation.class);
            ManagedProperty property_annotation = field.getAnnotation(ManagedProperty.class);
            ManagedEvent event_annotation = field.getAnnotation(ManagedEvent.class);
            if (relation_annotation != null) {
                Method[] relationMethods = ManagedProxyInvocationHandler.getRelationMethods(relation_annotation, field, resourceClass);
                if (relationMethods[0] != null && relationMethods[1] != null) {
                    annotations = field.getAnnotations();
                    this.addMethods.put(relationMethods[0], annotations);
                    this.removeMethods.put(relationMethods[1], annotations);
                    this.interceptedMethods.put(relationMethods[0], relationMethods[0]);
                    this.interceptedMethods.put(relationMethods[1], relationMethods[1]);
                    if (event_annotation != null) {
                        this.eventMethods.put(relationMethods[0], annotations);
                        this.eventMethods.put(relationMethods[1], annotations);
                    }
                }
            } else if (property_annotation != null && event_annotation != null) {
                Method[] beanMethods = ManagedProxyInvocationHandler.getBeanMethods(property_annotation, field, resourceClass);
                annotations = field.getAnnotations();
                if (event_annotation != null && beanMethods[0] != null && beanMethods[1] != null) {
                    this.getterMethods.put(beanMethods[0], annotations);
                    this.setterMethods.put(beanMethods[1], annotations);
                    this.interceptedMethods.put(beanMethods[0], beanMethods[0]);
                    this.interceptedMethods.put(beanMethods[1], beanMethods[1]);
                }
            }
            ++n2;
        }
        Method[] methodArray = methods = resourceClass.getMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            Method method = methodArray[n];
            CreateManagedRelation create_relation_annotation = this.getAnnotation(method, CreateManagedRelation.class);
            DestroyManagedRelation destroy_relation_annotation = this.getAnnotation(method, DestroyManagedRelation.class);
            ManagedEvent event_annotation = this.getAnnotation(method, ManagedEvent.class);
            if (create_relation_annotation != null) {
                this.addMethods.put(method, this.getAnnotations(method));
                this.interceptedMethods.put(method, method);
            } else if (destroy_relation_annotation != null) {
                this.removeMethods.put(method, this.getAnnotations(method));
                this.interceptedMethods.put(method, method);
            }
            if (event_annotation != null) {
                this.interceptedMethods.put(method, method);
                this.eventMethods.put(method, this.getAnnotations(method));
            }
            ++n;
        }
        this.getDuplicateMethods();
    }

    public <A extends Annotation> A getAnnotation(Method method, Class<A> target) {
        Class<?>[] interfaces;
        if (method.getAnnotation(target) != null) {
            System.out.println("Target has annotation " + target.getName() + " method " + method.getName());
            return method.getAnnotation(target);
        }
        Class<?>[] classArray = interfaces = this.wrappedObject.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Class<?> interfaze = classArray[n2];
            Method[] methodArray = methods = interfaze.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method imethod = methodArray[n4];
                if (this.equivelentMethod(imethod, method) && imethod.getAnnotation(target) != null) {
                    return imethod.getAnnotation(target);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public Annotation[] getAnnotations(Method method) {
        Class<?>[] interfaces;
        Annotation[] annotations = method.getAnnotations();
        HashMap map = new HashMap();
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annon = annotationArray[n2];
            map.put(annon.getClass(), annon);
            ++n2;
        }
        Class<?>[] classArray = interfaces = this.wrappedObject.getClass().getInterfaces();
        int n3 = interfaces.length;
        n = 0;
        while (n < n3) {
            Class<?> interfaze = classArray[n];
            Method[] methods = interfaze.getMethods();
            ManagedResourceCapability cap = interfaze.getAnnotation(ManagedResourceCapability.class);
            if (cap != null) {
                cap.namespace();
            }
            Method[] methodArray = methods;
            int n4 = methods.length;
            int n5 = 0;
            while (n5 < n4) {
                Method imethod = methodArray[n5];
                if (this.equivelentMethod(imethod, method)) {
                    Annotation[] iannotations;
                    Annotation[] annotationArray2 = iannotations = imethod.getAnnotations();
                    int n6 = iannotations.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Annotation annon = annotationArray2[n7];
                        if (map.get(annon.getClass()) == null) {
                            String namespace;
                            map.put(annon.getClass(), annon);
                            Class<? extends Annotation> type = annon.annotationType();
                            if (type.equals(ManagedEvent.class) && "".equals(namespace = ((ManagedEvent)annon).namespace())) {
                                cap.getClass();
                                map.put(cap.getClass(), cap);
                            }
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
            ++n;
        }
        return map.values().toArray(new Annotation[0]);
    }

    public ManagedProxyInvocationHandler(Object wrappedObject) {
        this.wrappedObject = wrappedObject;
        this.processAnnotations();
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        if (method.equals(getProxiedClassMethod)) {
            return this.wrappedObject.getClass();
        }
        if (method.equals(getProxiedObjectMethod)) {
            return this.wrappedObject;
        }
        if (method.equals(getProxiedMethodMethod)) {
            return this.interceptedMethods.get(method);
        }
        boolean wrapMethod = false;
        boolean isAdd = false;
        boolean isRemove = false;
        boolean isSet = false;
        boolean isEvent = false;
        boolean success = false;
        Object ret = null;
        if (this.interceptedMethods.get(method) != null) {
            wrapMethod = true;
            if (this.addMethods.get(method) != null) {
                isAdd = true;
            } else if (this.removeMethods.get(method) != null) {
                isRemove = true;
            } else if (this.setterMethods.get(method) != null) {
                isSet = true;
            }
            if (this.eventMethods.get(method) != null) {
                isEvent = true;
            }
        }
        if (wrapMethod) {
            try {
                if (isSet && isEvent) {
                    this.preProcessAttributeChange(obj, method, args);
                }
                ret = method.invoke(this.wrappedObject, args);
                success = true;
                Object object = ret;
                return object;
            }
            finally {
                if (success) {
                    System.out.println("Some kind of event or relationship processing goes here");
                    if (isAdd) {
                        this.postProcessAdd(obj, method, args);
                    } else if (isRemove) {
                        this.postProcessRemove(obj, method, args);
                    } else if (isSet) {
                        this.postProcessAttributeChange(obj, method, args);
                    }
                    if (isEvent) {
                        this.raiseEvent(obj, method, args, ret);
                    }
                }
            }
        }
        return method.invoke(this.wrappedObject, args);
    }

    private void postProcessAdd(Object obj, Method method, Object[] args) {
        Annotation[] annotations = this.addMethods.get(method);
        manager.addRelationship(obj, method, args, annotations);
    }

    private void postProcessRemove(Object obj, Method method, Object[] args) {
        Annotation[] annotations = this.removeMethods.get(method);
        manager.removeRelationship(obj, method, args, annotations);
    }

    private void preProcessAttributeChange(Object obj, Method method, Object[] args) {
    }

    private void postProcessAttributeChange(Object obj, Method method, Object[] args) {
    }

    private void raiseEvent(Object obj, Method method, Object[] args, Object ret) {
        Annotation[] annotations = this.eventMethods.get(method);
        manager.raiseEvent(this.wrappedObject, method, args, ret, annotations);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    void computeProxiedMethodMap(Object proxyObject) {
        Class<?> proxyClass = proxyObject.getClass();
        if (!ManagementProxy.class.isAssignableFrom(proxyClass)) {
            return;
        }
        for (Method interceptedMethod : this.interceptedMethods.keySet()) {
            try {
                Method proxyMethod = proxyClass.getMethod(interceptedMethod.getName(), interceptedMethod.getParameterTypes());
                this.interceptedMethods.put(interceptedMethod, proxyMethod);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }
}

