/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.net.InetAddress;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentConfiguration;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.AgentNotRegisteredException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.QueueManager;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.logging.core.LoggingAgentCustomCommand;
import org.eclipse.hyades.logging.core.LoggingAgentCustomCommandHandler;
import org.eclipse.hyades.logging.core.LoggingAgentMonitorListener;

public class LoggingAgent {
    public static final String LOGGING_AGENT_TYPE = "Logging";
    private RemoteComponentSkeleton delegate;
    private QueueManager queue;
    private boolean controllerAvailable = false;
    private boolean isMonitored = false;
    private Object currentThreadLock = new Object();

    public LoggingAgent(String name) {
        this(name, 100, LOGGING_AGENT_TYPE);
    }

    public LoggingAgent(String name, String type) {
        this(name, 100, type);
    }

    public LoggingAgent(String name, int bufferSize, String type) {
        this.queue = new QueueManager(bufferSize);
        try {
            this.delegate = new RemoteComponentSkeleton(name, type);
            this.delegate.addAgentControllerListener(new AgentControllerListener(){

                public void agentControllerActive() {
                    LoggingAgent.this.controllerAvailable = true;
                }

                public void agentControllerInactive() {
                    LoggingAgent.this.controllerAvailable = false;
                }
            });
            this.delegate.addMonitorListener(new MonitorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void monitorActive() {
                    Object object = LoggingAgent.this.currentThreadLock;
                    synchronized (object) {
                        LoggingAgent.this.isMonitored = true;
                        LoggingAgent.this.currentThreadLock.notify();
                    }
                    LoggingAgent.this.flush();
                }

                public void monitorInactive() {
                    LoggingAgent.this.isMonitored = false;
                    LoggingAgent.this.flush();
                }
            });
            this.delegate.initialize();
        }
        catch (Throwable throwable) {
            this.controllerAvailable = false;
        }
    }

    public LoggingAgent(String name, int bufferSize) {
        this(name, bufferSize, LOGGING_AGENT_TYPE);
    }

    public AgentConfiguration getLoggingAgentDefaultConfiguration() {
        return this.delegate.getDefaultConfiguration();
    }

    public boolean isLogging() {
        return this.controllerAvailable && this.isMonitored;
    }

    public void write(String msg) {
        if (this.isLogging()) {
            this.delegate.logMessageUTF8(msg);
        } else {
            this.enQueue(msg);
        }
    }

    public void enQueue(String msg) {
        this.queue.insertInQueue(msg);
    }

    public void flush() {
        if (this.queue.isFlushNeeded()) {
            this.queue.flushCurrentQueue(this.delegate);
        }
    }

    public void deregister() {
        this.delegate.deregister();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getType() {
        return this.delegate.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilLogging(long maxTime) {
        Object object = this.currentThreadLock;
        synchronized (object) {
            try {
                if (!this.isLogging()) {
                    this.currentThreadLock.wait(maxTime);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.isLogging();
    }

    public void logErrorMessage(String message, String messageId, int severity) {
        this.delegate.logErrMsg(message, messageId, severity);
    }

    public void requestMonitorThroughPeer_p(InetAddress addr, long port, String agentUUID, long timeout) {
        this.delegate.requestMonitorThroughPeer_p(addr, port, agentUUID, timeout);
    }

    public void requestMonitorThroughPeer(InetAddress addr, String agentUUID, long timeout) {
        this.delegate.requestMonitorThroughPeer(addr, agentUUID, timeout);
    }

    public void requestMonitorThroughPeer_p(InetAddress addr, long port, long pid, String agentName, long timeout) {
        this.delegate.requestMonitorThroughPeer_p(addr, port, pid, agentName, timeout);
    }

    public void requestMonitorThroughPeer(InetAddress addr, long pid, String agentName, long timeout) {
        this.delegate.requestMonitorThroughPeer(addr, pid, agentName, timeout);
    }

    public long getPID() {
        return this.delegate.getPID();
    }

    public String getAgentUUID() {
        return this.delegate.getAgentUUID();
    }

    public String generateUUID() {
        return this.delegate.generateUUID();
    }

    public String getNodeUUID() throws AgentNotRegisteredException {
        return this.delegate.getNodeUUID();
    }

    public String getJVMUUID() throws AgentNotRegisteredException {
        return this.delegate.getJVMUUID();
    }

    public void broadcastMessage(String message, long contextId) {
        this.delegate.broadcastMessage(message, contextId);
    }

    public void broadcastMessage(byte[] message, int offset, int length, long contextId) {
        this.delegate.broadcastMessage(message, offset, length, contextId);
    }

    public void addMonitorListener(final LoggingAgentMonitorListener listener) {
        this.delegate.addMonitorListener(new MonitorListener(){

            public void monitorActive() {
                listener.loggingAgentMonitorActive();
            }

            public void monitorInactive() {
                listener.loggingAgentMonitorInactive();
            }
        });
    }

    public void addCommandListener(final LoggingAgentCustomCommandHandler listener) {
        this.delegate.addCommandListener(new CustomCommandHandler(){

            public void handleCommand(CustomCommand command) {
                listener.handleLoggingAgentCustomCommand(new LoggingAgentCustomCommand(command.getData()));
            }
        });
    }

    public boolean isAgentControllerAvailable() {
        return this.controllerAvailable;
    }
}

