/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.logging.datamgr;

import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.dc.dataManager.impl.AbstractDataManager;
import org.eclipse.cosmos.dc.logging.datamgr.api.ILogEventCollector;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.apache.muse.util.xml.XmlUtils;

@ManagedResource
public class LoggingDataManager extends AbstractDataManager implements IDataManager, ILogEventCollector {

	public Element getCBEs(String logfile) throws CosmosException {
		String f = new String("/logs/" + logfile);
		URL resource = this.getClass().getClassLoader().getResource( f);
		Element data = null;
		Document doc = null;
				
		if (resource != null) {
			doc = getConfigDocument( resource );
        	Element elem = XmlUtils.createElement(ILogEventCollector.GET_ALL_CBE_OP_QNAME);
        	data = (Element) XmlUtils.moveSubTree( doc.getFirstChild(), elem);     
      	}
		else
			throw new CosmosException();
		
		return data;
   	}

	public String[] getCBESeverityCount(String logfile) throws CosmosException {
		// TODO Auto-generated method stub
		return null;
	}

	public String[] getLogFileIdentifiers() throws CosmosException {
		String[] ret = new String[2];
		String dir = getConfigProperty("CBEData.dir");
		
		ret = listPath(new File(dir));
		return ret;
	}
	
	private String[] listPath(File path)
	{
	    File[] files; 
	    String[] l = null;
	    String[] ret = null;
	    int cnt = 0;
	    int i = 0;
	    int n = 0;
	    int idx = 0;
	    
	    if (!path.isDirectory()) {
	    	System.out.println("Not a directory.");
	    	return null;
	    }
	    	
	    files = path.listFiles();

	    if ((files != null) && (files.length > 0)) {
	    	Arrays.sort(files);	
	    	n = files.length;
	    	l = new String[n];
	    	for (i = 0; i < n; i++) {
	    		if (!files[i].isDirectory())
	    			l[cnt++] = new String(files[i].toString());
	    	}
	    	ret = new String[cnt];
	    	for (i=0;i<cnt;i++) {
	    		idx = l[i].lastIndexOf('\\');
	       		ret[i] = l[i].substring(idx+1);
	       	}
	    }
	    else
	    	return null;
	    
	    return ret;
	}
	private Document getConfigDocument( URL resource ){
		Document doc = null;
		if ( resource != null ){
			InputStream contextStream;
			try {
				contextStream = resource.openStream();
				// doc = XmlUtils.createDocument(contextStream);
				doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contextStream);
			} catch (Exception ex) {
				//error?
		        System.out.println( "getConfigDocument Exception = " + ex.getMessage() );
				return doc;
			}
		}

		return doc;
	}
	
}
