/*******************************************************************************
 * Copyright (c) 2008 Computer Associates.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Computer Associates - initial implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.stat.datamgr.api;
import javax.xml.namespace.QName;

import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResourceCapability;
import org.w3c.dom.Element;

@ManagedResourceCapability(namespace=IStat.NAMESPACE_URI)
public interface IStat {

		public static final String NAMESPACE_URI = "http://www.eclipse.org/cosmos/Statistical";
		
		String PREFIX = "stat";
		
		String GET_KEYSET_OP_URI = NAMESPACE_URI + "/getDatasourceKeysets";
		QName GET_KEYSET_OP_QNAME = new QName(NAMESPACE_URI, "getDatasourceKeysets", PREFIX);
		
		String GET_STAT_OP_URI = NAMESPACE_URI + "/getStatDataForSources";
		QName GET_STAT_OP_QNAME = new QName(NAMESPACE_URI, "getStatDataForSources", PREFIX);
		QName GET_STAT_DATASET_QNAME = new QName(GET_STAT_OP_URI, "dataset", PREFIX);
		QName GET_STAT_KEYSET_QNAME = new QName(GET_STAT_OP_URI, "keyset", PREFIX);
		QName GET_STAT_START_QNAME = new QName(GET_STAT_OP_URI,"start",PREFIX);
		QName GET_STAT_SIZE_QNAME = new QName(GET_STAT_OP_URI,"size",PREFIX);
		
		QName GET_STAT_OBSERVATIONS_QNAME = new QName(GET_STAT_OP_URI,"observations",PREFIX);
		QName GET_STAT_OBSERVATION_QNAME = new QName(GET_STAT_OP_URI,"observation",PREFIX);
		QName GET_STAT_STRING_QNAME = new QName(GET_STAT_OP_URI,"string",PREFIX);
		QName GET_STAT_INTEGER_QNAME = new QName(GET_STAT_OP_URI,"integer",PREFIX);
		QName GET_STAT_DOUBLE_QNAME = new QName(GET_STAT_OP_URI,"double",PREFIX);
		QName GET_STAT_DATE_QNAME = new QName(GET_STAT_OP_URI,"date",PREFIX);
		
		@ManagedOperation
		public String[] getDatasourceKeysets() throws CosmosException;

		@ManagedOperation
		public Element getStatDataForSources(String dataset,String keyset,int start, int size) throws CosmosException;
}

