/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.AttributeIterator;
import org.apache.xpath.axes.ChildTestIterator;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes.EChildTestIterator;

public class EAttributeIterator
extends EChildTestIterator {
    private AttributeIterator node;

    public IExpression instance(Expression e) {
        return new EAttributeIterator((AttributeIterator)e);
    }

    public EAttributeIterator(AttributeIterator node) {
        super((ChildTestIterator)node);
        this.node = node;
    }

    public Object[] execute(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        Object[] resultArr;
        Object obj = context.getObject();
        String name = this.getLocalName();
        if (name.equals("") || obj == null) {
            return new Object[0];
        }
        if (this.node.getPredicateCount() > 0) {
            if (name.equals("*")) {
                String[] attributes = context.getBindingMetaData().getAttributes(obj);
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < attributes.length) {
                    Object[] tmpArr = context.get(attributes[i], 4);
                    int j = 0;
                    while (j < tmpArr.length) {
                        list.add(tmpArr[j]);
                        ++j;
                    }
                    ++i;
                }
                resultArr = this.processEPredicates(list.toArray(), context);
            } else {
                Object[] tmpArr = context.get(name, 3);
                resultArr = tmpArr == null ? new Object[]{} : this.processEPredicates(tmpArr, context);
            }
        } else if (name.equals("*")) {
            String[] attributes = context.getBindingMetaData().getAttributes(obj);
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < attributes.length) {
                Object[] oArr = context.get(attributes[i]);
                int j = 0;
                while (j < oArr.length) {
                    list.add(oArr[j]);
                    ++j;
                }
                ++i;
            }
            resultArr = list.toArray();
        } else {
            resultArr = context.get(name, 3);
        }
        return resultArr;
    }

    public void compile(ICompilerContext compilationContext) throws CodeGenerationError {
        compilationContext.in(this);
        String name = this.getLocalName();
        if (name.equals("")) {
            return;
        }
        if (name.equals("*")) {
            throw new CodeGenerationError("Cannot generate code for *");
        }
        if (this.node.getPredicateCount() > 0) {
            this.compilePredicates(compilationContext);
        }
        compilationContext.addName(name);
        compilationContext.out();
    }
}

