/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.spi.impl;

import org.eclipse.cosmos.dc.common.spi.descriptor.IContextDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.DescriptorNode;
import org.eclipse.cosmos.dc.common.spi.impl.QueryDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.SourceDescriptor;

public class ContextDescriptor
extends DescriptorNode
implements IContextDescriptor {
    private String name;
    private int direction;
    private DescriptorNode rootChild;

    public void setName(String name) {
        this.name = name;
    }

    public void setDirection(int direction) {
        switch (direction) {
            case 1: 
            case 2: {
                this.direction = direction;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isInbound() {
        return this.direction == 1;
    }

    public boolean isOutbound() {
        return this.direction == 2;
    }

    public String getName() {
        return this.name;
    }

    protected void processChild(DescriptorNode child) {
        this.rootChild = child;
    }

    public boolean acceptChild(DescriptorNode child) throws Exception {
        if (this.rootChild != null) {
            return false;
        }
        if (this.isInbound() && child instanceof SourceDescriptor) {
            return true;
        }
        return this.isOutbound() && child instanceof QueryDescriptor;
    }

    public SourceDescriptor getSource() {
        if (this.rootChild instanceof SourceDescriptor) {
            return (SourceDescriptor)this.rootChild;
        }
        return null;
    }

    public QueryDescriptor getQuery() {
        if (this.rootChild instanceof QueryDescriptor) {
            return (QueryDescriptor)this.rootChild;
        }
        return null;
    }
}

