/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.local.registry;

import java.net.InetAddress;
import java.net.URI;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.eclipse.cosmos.dc.remote.wsdm.spec.ManagementDomainClient;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataBrokerRegistration
implements Runnable {
    String domainEPR;
    String domainResid;
    String epr;
    String resid;
    String name;
    String classification;
    public static int startupDelay = 10000;

    public DataBrokerRegistration(String domainEPR, String domainResid, String epr, String resid, String name, String classification) {
        this.domainEPR = domainEPR;
        this.domainResid = domainResid;
        this.epr = epr;
        this.resid = resid;
        this.classification = classification;
        this.name = name;
    }

    public void run() {
        try {
            Thread.sleep(startupDelay);
        }
        catch (InterruptedException interruptedException) {}
        try {
            URI domainURI = URI.create(this.domainEPR);
            String domainHost = domainURI.getHost();
            int domainPort = domainURI.getPort();
            EndpointReference domainEPR = new EndpointReference(domainURI);
            domainEPR.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)this.domainResid);
            ManagementDomainClient domainClient = new ManagementDomainClient(domainEPR);
            if (domainHost.equalsIgnoreCase("localhost") || domainHost.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                ManagementDomainClient.loadManagementDomainContext((String)domainHost, (int)new Integer(domainPort));
            }
            Element result = domainClient.getBrokers(this.name, this.classification);
            NodeList nodeList = result.getElementsByTagName("Broker");
            int nodeCount = nodeList.getLength();
            int index = 0;
            while (index < nodeCount) {
                Element element;
                String ename;
                if (nodeList.item(index).getNodeType() == 1 && (ename = (element = (Element)nodeList.item(index)).getAttribute("name")) != null && ename.equalsIgnoreCase(this.name)) {
                    domainClient.pingManagementDomain(this.name);
                    return;
                }
                ++index;
            }
            domainClient.registerBroker(this.epr, this.resid, this.name, this.classification);
        }
        catch (Exception ex) {
            System.out.println("DataBrokerRegistration Exception = " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

