/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.spi.OutboundContext;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.cosmos.dc.spec.capabilitiy.CBEQueryCapability;
import org.eclipse.cosmos.dc.spec.capabilitiy.DataBrokerCapability;
import org.eclipse.cosmos.dc.spec.capabilitiy.ManagementDomainCapability;
import org.eclipse.cosmos.dc.spec.capabilitiy.StatisticalQueryCapability;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConsoleExtension
implements CommandProvider {
    BundleContext context;
    private static RuntimeHost runtime;
    private static final int STAT_KEYSET_QUERY = 1;
    private static final int STAT_DIMENSION_QUERY = 2;
    private static final int STAT_PARTIAL_KEYSET_QUERY = 3;
    private static final String[] EMPTY_STRING_ARRAY;
    int pageSize = 0;
    int pageStart = 0;
    Date start = null;
    Date stop = null;

    static {
        EMPTY_STRING_ARRAY = new String[0];
    }

    public static void setRuntime(RuntimeHost rt) {
        runtime = rt;
    }

    public ConsoleExtension(BundleContext context) {
        this.context = context;
        Hashtable props = new Hashtable();
        context.registerService(CommandProvider.class.getName(), (Object)this, props);
    }

    public void _spec(CommandInterpreter ci) throws Exception {
        if (runtime == null) {
            System.out.println("No Runtime availabie");
            return;
        }
        this.start = null;
        this.stop = null;
        this.pageStart = 0;
        this.pageSize = 0;
        boolean paged = false;
        String key = ci.nextArgument();
        if ("query".equals(key)) {
            key = ci.nextArgument();
            if ("stat".equals(key)) {
                String name = ci.nextArgument();
                String dataset = ci.nextArgument();
                String keyset = ci.nextArgument();
                String tok = ci.nextArgument();
                IDataCollectionContext assembly = runtime.getContextForName(name);
                if (assembly == null) {
                    System.out.println("Target assembly " + name + " not found");
                    return;
                }
                if (!(assembly instanceof OutboundContext)) {
                    System.out.println("Target assembly " + name + " does not support Queries");
                    return;
                }
                IDataQueryService queryComponent = ((OutboundContext)assembly).getRootQuery();
                if (!(queryComponent instanceof StatisticalQueryCapability)) {
                    System.out.println("Query root of target assembly " + name + " does not support Statistical Queries");
                    return;
                }
                int queryType = 1;
                ArrayList<String> dimList = new ArrayList<String>();
                if ("dim".equals(tok)) {
                    queryType = 2;
                    tok = ci.nextArgument();
                    if (tok == null) {
                        System.out.println("No dimension supplied for dimension query");
                        return;
                    }
                    dimList.add(tok);
                    tok = ci.nextArgument();
                    if ("paged".equals(tok)) {
                        paged = true;
                        this.getPageRange(tok, ci);
                    } else {
                        this.getDateRange(tok, ci);
                    }
                } else if ("dims".equals(tok)) {
                    queryType = 3;
                    tok = ci.nextArgument();
                    if (!"(".equals(tok)) {
                        System.out.println("Invalid Syntax for partial keyset query: spec query stat %ASSEMBLY% %DSNAME% %KEYSET% dims (%DIMENSION%*) [%START% %STOP]");
                        return;
                    }
                    boolean foundClose = false;
                    while ((tok = ci.nextArgument()) != null) {
                        if (")".equals(tok)) {
                            foundClose = true;
                            break;
                        }
                        dimList.add(tok);
                    }
                    if (!foundClose) {
                        System.out.println("Invalid Syntax for partial keyset query: spec query stat %ASSEMBLY% %DSNAME% %KEYSET% dims (%DIMENSION%*) [%START% %STOP]");
                        return;
                    }
                    if (dimList.isEmpty()) {
                        System.out.println("No dimensions provided for partial keyset query");
                        return;
                    }
                    tok = ci.nextArgument();
                    if ("paged".equals(tok)) {
                        paged = true;
                        this.getPageRange(tok, ci);
                    } else {
                        this.getDateRange(tok, ci);
                    }
                } else if (tok != null) {
                    if ("paged".equals(tok)) {
                        paged = true;
                        this.getPageRange(tok, ci);
                    } else {
                        this.getDateRange(tok, ci);
                    }
                }
                tok = ci.nextArgument();
                if (tok != null) {
                    this.getDateRange(tok, ci);
                }
                this.executeQuery((StatisticalQueryCapability)queryComponent, dataset, keyset, dimList.toArray(EMPTY_STRING_ARRAY), this.start, this.stop, queryType, paged, this.pageStart, this.pageSize);
            } else if (key.equals("cbe")) {
                IDataQueryService queryComponent;
                CBEQueryCapability cbequery;
                IDataQueryResult<CommonBaseEvent> result;
                Collection resultCollection;
                String dataset = ci.nextArgument();
                IDataCollectionContext assembly = runtime.getContextForName("CBEQuery");
                if (assembly == null) {
                    System.err.println("Invalid assembly name: CBEQuery");
                }
                if ((resultCollection = (result = (cbequery = (CBEQueryCapability)(queryComponent = ((OutboundContext)assembly).getRootQuery())).getAllCBE(dataset)).getRawResponseCollection()) instanceof List) {
                    List cfr_ignored_0 = (List)resultCollection;
                }
            } else if (key.equals("cbeCount")) {
                IDataQueryService queryComponent;
                CBEQueryCapability cbequery;
                IDataQueryResult result;
                Collection resultCollection;
                String dataset = ci.nextArgument();
                IDataCollectionContext assembly = runtime.getContextForName("CBECount");
                if (assembly == null) {
                    System.err.println("Invalid assembly name: CBECount");
                }
                if ((resultCollection = (result = (cbequery = (CBEQueryCapability)(queryComponent = ((OutboundContext)assembly).getRootQuery())).getCBECountBySeverity(dataset)).getRawResponseCollection()) instanceof List) {
                    List cfr_ignored_1 = (List)resultCollection;
                }
            }
        }
    }

    public void _domain(CommandInterpreter ci) throws Exception {
        String lineBreak = System.getProperty("line.separator");
        String usage = "Usage: domain query <classification> <BrokerName>" + lineBreak + "       domain register EPAddress EPResourceID BrokerName classification " + lineBreak + "       domain deregister BrokerName";
        if (runtime == null) {
            System.out.println("No Runtime availabie");
            return;
        }
        this.start = null;
        this.stop = null;
        this.pageStart = 0;
        this.pageSize = 0;
        String key = ci.nextArgument();
        if (key != null && "query".equals(key)) {
            String classification = ci.nextArgument();
            String brokerName = ci.nextArgument();
            IDataCollectionContext assembly = runtime.getContextForName("ManagementDomain");
            if (assembly == null) {
                System.err.println("Assembly context not found: ManagementDomain");
                return;
            }
            IDataQueryService queryComponent = ((OutboundContext)assembly).getRootQuery();
            ManagementDomainCapability domainQuery = (ManagementDomainCapability)queryComponent;
            IDataQueryResult result = domainQuery.getBrokers(brokerName, classification);
            Object resp = result.getRawResponse();
            if (resp instanceof String) {
                System.out.println((String)resp);
            } else if (resp instanceof Element) {
                System.out.println(XmlUtils.toString((Node)((Element)resp)));
            } else {
                System.out.println(resp.toString());
            }
        } else if (key != null && "register".equals(key)) {
            String epr = ci.nextArgument();
            String resid = ci.nextArgument();
            String name = ci.nextArgument();
            String classification = ci.nextArgument();
            IDataCollectionContext _assembly = runtime.getContextForName("ManagementDomain");
            if (_assembly == null) {
                System.err.println("Assembly context not found: ManagementDomain");
                return;
            }
            IDataQueryService queryComponent = ((OutboundContext)_assembly).getRootQuery();
            ManagementDomainCapability domainQuery = (ManagementDomainCapability)queryComponent;
            if (classification != null) {
                domainQuery.registerBroker(epr, resid, name, classification);
            } else {
                System.out.println(usage);
            }
        } else if (key != null && "deregister".equals(key)) {
            String name = ci.nextArgument();
            IDataCollectionContext _assembly = runtime.getContextForName("ManagementDomain");
            if (_assembly == null) {
                System.err.println("Assembly context not found: ManagementDomain");
                return;
            }
            IDataQueryService queryComponent = ((OutboundContext)_assembly).getRootQuery();
            ManagementDomainCapability domainQuery = (ManagementDomainCapability)queryComponent;
            if (name != null) {
                domainQuery.deregisterBroker(name);
            } else {
                System.out.println(usage);
            }
        } else {
            System.out.println(usage);
        }
    }

    public void _broker(CommandInterpreter ci) throws Exception {
        String lineBreak = System.getProperty("line.separator");
        String usage = "Usage: broker query <classification>" + lineBreak + "       broker register EPAddress EPResourceID DataManagerName classification dialect" + lineBreak + "       broker deregister DataManagerName";
        if (runtime == null) {
            System.out.println("No Runtime availabie");
            return;
        }
        this.start = null;
        this.stop = null;
        this.pageStart = 0;
        this.pageSize = 0;
        String key = ci.nextArgument();
        if (key != null && "query".equals(key)) {
            IDataCollectionContext assembly;
            String classification = ci.nextArgument();
            if (classification == null) {
                classification = "all";
            }
            if ((assembly = runtime.getContextForName("DataBroker")) == null) {
                System.err.println("Assembly context not found: DataBroker");
                return;
            }
            IDataQueryService queryComponent = ((OutboundContext)assembly).getRootQuery();
            DataBrokerCapability brokerQuery = (DataBrokerCapability)queryComponent;
            IDataQueryResult result = brokerQuery.getDataManagers(classification);
            Object resp = result.getRawResponse();
            if (resp instanceof String) {
                System.out.println((String)resp);
            } else if (resp instanceof Element) {
                System.out.println(XmlUtils.toString((Node)((Element)resp)));
            } else {
                System.out.println(resp.toString());
            }
        } else if (key != null && "register".equals(key)) {
            String epr = ci.nextArgument();
            String resid = ci.nextArgument();
            String name = ci.nextArgument();
            String classification = ci.nextArgument();
            String dialect = ci.nextArgument();
            IDataCollectionContext _assembly = runtime.getContextForName("DataBroker");
            if (_assembly == null) {
                System.err.println("Assembly context not found: DataBroker");
                return;
            }
            IDataQueryService queryComponent = ((OutboundContext)_assembly).getRootQuery();
            DataBrokerCapability brokerQuery = (DataBrokerCapability)queryComponent;
            if (dialect != null) {
                brokerQuery.registerDataManager(epr, resid, name, classification, dialect);
            } else {
                System.out.println(usage);
            }
        } else if (key != null && "deregister".equals(key)) {
            String name = ci.nextArgument();
            IDataCollectionContext _assembly = runtime.getContextForName("DataBroker");
            if (_assembly == null) {
                System.err.println("Assembly context not found: DataBroker");
                return;
            }
            IDataQueryService queryComponent = ((OutboundContext)_assembly).getRootQuery();
            DataBrokerCapability brokerQuery = (DataBrokerCapability)queryComponent;
            if (name != null) {
                brokerQuery.deregisterDataManager(name);
            } else {
                System.out.println(usage);
            }
        } else {
            System.out.println(usage);
        }
    }

    public void stop() {
    }

    public String getHelp() {
        return "spec ";
    }

    private void getDateRange(String tok, CommandInterpreter ci) throws Exception {
        if (tok != null) {
            this.start = new Date(tok);
            tok = ci.nextArgument();
            tok = ci.nextArgument();
            if (tok != null) {
                this.stop = new Date(tok);
            }
        }
    }

    private void getPageRange(String tok, CommandInterpreter ci) throws Exception {
        if (tok != null) {
            String startTok = ci.nextArgument();
            this.pageStart = Integer.parseInt(startTok);
            String sizeTok = ci.nextArgument();
            this.pageSize = Integer.parseInt(sizeTok);
        }
    }

    private void executeQuery(StatisticalQueryCapability query, String dataset, String keyset, String[] dimList, Date start, Date stop, int queryType, boolean isPaged, int pageStart, int pageSize) throws Exception {
        IDataQueryResult<StatisticalTuple> result = null;
        switch (queryType) {
            case 2: {
                if (isPaged) {
                    result = query.pagedDimensionQuery("StatisticalTuple", dataset, keyset, dimList[0], start, stop, pageStart, pageSize);
                    break;
                }
                result = query.dimensionQuery("StatisticalTuple", dataset, keyset, dimList[0], start, stop);
                break;
            }
            case 1: {
                if (isPaged) {
                    result = query.pagedKeysetQuery("StatisticalTuple", dataset, keyset, start, stop, pageStart, pageSize);
                    break;
                }
                result = query.keysetQuery("StatisticalTuple", dataset, keyset, start, stop);
                break;
            }
            case 3: {
                result = isPaged ? query.pagedPartialKeysetQuery("StatisticalTuple", dataset, keyset, dimList, start, stop, pageStart, pageSize) : query.partialKeysetQuery("StatisticalTuple", dataset, keyset, dimList, start, stop);
            }
        }
        if (result != null) {
            Collection stats = result.getRawResponseCollection();
            System.out.println("Printing first 100 results:");
            int i = 0;
            if (stats != null) {
                for (Object stat : stats) {
                    System.out.println("  " + stat);
                    if (++i == 100) break;
                }
            }
        }
    }
}

