/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.addressing;

import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EndpointReference
implements XmlSerializable {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$addressing$EndpointReference == null ? (class$org$apache$muse$ws$addressing$EndpointReference = EndpointReference.class$("org.apache.muse.ws.addressing.EndpointReference")) : class$org$apache$muse$ws$addressing$EndpointReference));
    private URI _address = null;
    private Element _parameters = null;
    private QName _rootName = null;
    private Element _xml = null;
    static /* synthetic */ Class class$org$apache$muse$ws$addressing$EndpointReference;

    public EndpointReference(Element root) throws SoapFault {
        this(root, true);
    }

    public EndpointReference(Element root, boolean makeDeepCopyOfXML) throws SoapFault {
        if (root == null) {
            throw new NullPointerException(_MESSAGES.get("NullEPRElement"));
        }
        this._xml = makeDeepCopyOfXML ? (Element)XmlUtils.EMPTY_DOC.importNode(root, true) : root;
        this.initializeFromXML();
    }

    public EndpointReference(EndpointReference copy) {
        this(copy, WsaConstants.EPR_QNAME);
    }

    public EndpointReference(EndpointReference copy, QName typeName) {
        if (copy == null) {
            throw new NullPointerException(_MESSAGES.get("NullCopyEPR"));
        }
        if (typeName == null) {
            throw new NullPointerException(_MESSAGES.get("NullEPRTypeQName"));
        }
        Document doc = XmlUtils.EMPTY_DOC;
        this._xml = XmlUtils.createElement((Document)doc, (QName)typeName);
        NodeList children = copy.toXML().getChildNodes();
        int length = children.getLength();
        for (int n = 0; n < length; ++n) {
            Node next = doc.importNode(children.item(n), true);
            this._xml.appendChild(next);
        }
        try {
            this.initializeFromXML();
        }
        catch (SoapFault error) {
            throw new RuntimeException(_MESSAGES.get("InvalidEPRCreated"), error);
        }
    }

    public EndpointReference(URI address) {
        this(address, WsaConstants.EPR_QNAME);
    }

    public EndpointReference(URI address, QName typeName) {
        if (address == null) {
            throw new NullPointerException(_MESSAGES.get("NullToAddress"));
        }
        if (typeName == null) {
            throw new NullPointerException(_MESSAGES.get("NullEPRTypeQName"));
        }
        this._address = address;
        Document doc = XmlUtils.EMPTY_DOC;
        this._xml = XmlUtils.createElement((Document)doc, (QName)typeName);
        Element addressNode = XmlUtils.createElement((Document)doc, (QName)WsaConstants.ADDRESS_QNAME, (Object)address);
        this._xml.appendChild(addressNode);
        this._parameters = XmlUtils.createElement((Document)doc, (QName)WsaConstants.PARAMETERS_QNAME);
    }

    public void addParameter(Element parameter) {
        if (parameter == null) {
            throw new NullPointerException(_MESSAGES.get("NullReferenceParameter"));
        }
        if (!this._parameters.hasChildNodes()) {
            this._xml.appendChild(this._parameters);
        }
        Document doc = this._xml.getOwnerDocument();
        parameter = (Element)doc.importNode(parameter, true);
        this._parameters.appendChild(parameter);
    }

    public void addParameter(QName qname) {
        this.addParameter(qname, null);
    }

    public void addParameter(QName qname, Object value) {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullParameterQName"));
        }
        Element parameter = XmlUtils.createElement((QName)qname, (Object)value);
        this.addParameter(parameter);
    }

    public boolean equals(Object obj) {
        Element[] values2;
        String thatPath;
        if (obj == null) {
            return false;
        }
        EndpointReference that = (EndpointReference)obj;
        String thisPath = this.getAddress().getPath();
        if (!thisPath.equals(thatPath = that.getAddress().getPath())) {
            return false;
        }
        Element[] values1 = this.getParameters();
        if (values1.length != (values2 = that.getParameters()).length) {
            return false;
        }
        for (int n = 0; n < values1.length; ++n) {
            if (XmlUtils.equals((Element)values1[n], (Element)values2[n])) continue;
            return false;
        }
        return true;
    }

    public URI getAddress() {
        return this._address;
    }

    public int getNumberOfParameters() {
        return this._parameters.getChildNodes().getLength();
    }

    public Element getParameter(QName qname) {
        return this.getParameter(qname, 0);
    }

    public Element getParameter(QName qname, int index) {
        return XmlUtils.getElement((Node)this._parameters, (QName)qname, (int)index);
    }

    public Element[] getParameters() {
        return XmlUtils.getAllElements((Node)this._parameters);
    }

    public Element[] getParameters(QName qname) {
        return XmlUtils.getElements((Node)this._parameters, (QName)qname);
    }

    public String getParameterString(QName qname) {
        return this.getParameterString(qname, 0);
    }

    public String getParameterString(QName qname, int index) {
        Element xml = this.getParameter(qname, index);
        if (xml == null) {
            return null;
        }
        return XmlUtils.extractText((Element)xml);
    }

    public QName getRootTypeName() {
        return this._rootName;
    }

    public int hashCode() {
        String address = this.getAddress().getPath();
        Element[] parameters = this.getParameters();
        int paramHashCode = 0;
        for (int n = 0; n < parameters.length; ++n) {
            paramHashCode += XmlUtils.getHashCode((Element)parameters[n]);
        }
        return address.hashCode() + paramHashCode;
    }

    private void initializeFromXML() throws SoapFault {
        this._rootName = XmlUtils.getElementQName((Element)this._xml);
        String uri = XmlUtils.getElementText((Node)this._xml, (QName)WsaConstants.ADDRESS_QNAME);
        try {
            this._address = new URI(uri);
        }
        catch (Exception error) {
            Object[] filler = new Object[]{uri};
            String message = _MESSAGES.get("InvalidAddressURI", filler);
            throw new SoapFault(message, error);
        }
        Document doc = this._xml.getOwnerDocument();
        this._parameters = XmlUtils.getElement((Node)this._xml, (QName)WsaConstants.PARAMETERS_QNAME);
        if (this._parameters == null) {
            this._parameters = XmlUtils.createElement((Document)doc, (QName)WsaConstants.PARAMETERS_QNAME);
        }
    }

    public void removeParameter(QName qname) {
        this.removeParameter(qname, 0);
    }

    public void removeParameter(QName qname, int index) {
        Element match = XmlUtils.getElement((Node)this._parameters, (QName)qname, (int)index);
        if (match == null) {
            Object[] filler = new Object[]{qname};
            String message = _MESSAGES.get("NoParameterFound", filler);
            throw new IllegalArgumentException(message);
        }
        this._parameters.removeChild(match);
        if (!this._parameters.hasChildNodes()) {
            this._xml.removeChild(this._parameters);
        }
    }

    public void removeParameters(QName qname) {
        Element[] matches = XmlUtils.getElements((Node)this._parameters, (QName)qname);
        if (matches.length == 0) {
            Object[] filler = new Object[]{qname};
            String message = _MESSAGES.get("NoParametersFound", filler);
            throw new IllegalArgumentException(message);
        }
        for (int n = 0; n < matches.length; ++n) {
            this._parameters.removeChild(matches[n]);
        }
        if (!this._parameters.hasChildNodes()) {
            this._xml.removeChild(this._parameters);
        }
    }

    public void setAddress(URI address) {
        if (address == null) {
            throw new NullPointerException(_MESSAGES.get("NullToAddress"));
        }
        this._address = address;
        XmlUtils.setElement((Element)this._xml, (QName)WsaConstants.ADDRESS_QNAME, (Object)this._address);
    }

    public String toString() {
        return XmlUtils.toString((Node)this.toXML(), (boolean)false);
    }

    public Element toXML() {
        return this._xml;
    }

    public Element toXML(Document doc) {
        return (Element)doc.importNode(this._xml, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

