/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.samples.cmdbf.services.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository;

public class ItemRecordTypeHandler
extends AbstractItemConstraintHandler {
    private static final String RECORD_TYPE_STUDENT = "student";
    private static final String RECORD_TYPE_TEACHER = "teacher";
    private static final String RECORD_TYPE_CLASS = "class";

    protected INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException {
        IRecordType recordType = (IRecordType)constraint;
        String localName = recordType.getLocalName();
        XMLRepository repo = (XMLRepository)this.getValue("org.eclipse.cosmos.samples.cmdbf.services.query.ICMDBfSampleConstants");
        INodes result = QueryOutputArtifactFactory.getInstance().createNodes(context.getId());
        if (context.isStartingContext()) {
            if (RECORD_TYPE_STUDENT.equals(localName)) {
                this.addSchoolMembers(result, repo.students);
            } else if (RECORD_TYPE_TEACHER.equals(localName)) {
                this.addSchoolMembers(result, repo.teachers);
            } else if (RECORD_TYPE_CLASS.equals(localName)) {
                int i = 0;
                while (i < repo.classes.length) {
                    result.addItem((IItemConvertible)repo.classes[i]);
                    ++i;
                }
            }
            return result;
        }
        IGraphElement[] elements = context.getElements();
        int i = 0;
        while (i < elements.length) {
            IRecord[] records = elements[i].getRecords();
            int j = 0;
            while (j < records.length) {
                if (RECORD_TYPE_STUDENT.equals(localName) && records[j].getValue() instanceof XMLRepository.Student) {
                    result.addItem((IItem)elements[i]);
                } else if (RECORD_TYPE_TEACHER.equals(localName) && records[j].getValue() instanceof XMLRepository.Teacher) {
                    result.addItem((IItem)elements[i]);
                } else if (RECORD_TYPE_CLASS.equals(localName) && records[j].getValue() instanceof XMLRepository.ClassSession) {
                    result.addItem((IItem)elements[i]);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void addSchoolMembers(INodes result, XMLRepository.SchoolMember[] members) {
        int i = 0;
        while (i < members.length) {
            result.addItem((IItemConvertible)members[i]);
            ++i;
        }
    }
}

