/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.samples.cmdbf.services.query;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.samples.cmdbf.services.query.QueryHandlerFactory;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository;
import org.xml.sax.SAXException;

public class QueryLauncher {
    private static final String queryFile = "teaches-relationship.txt";

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException, URISyntaxException, CMDBfServiceException {
        InputStream query = QueryLauncher.class.getClassLoader().getResourceAsStream(queryFile);
        CMDBfQueryOperation queryOperation = new CMDBfQueryOperation((IQueryHandlerFactory)QueryHandlerFactory.getInstance(), null);
        Hashtable<String, XMLRepository> init = new Hashtable<String, XMLRepository>();
        init.put("org.eclipse.cosmos.samples.cmdbf.services.query.ICMDBfSampleConstants", new XMLRepository());
        queryOperation.initialize(init);
        IQueryResult result = queryOperation.execute(query);
        InputStream resultStream = QueryOutputTransformer.transform((IQueryResult)result);
        byte[] buffer = new byte[1024];
        while (resultStream.available() > 0) {
            int chars = resultStream.read(buffer);
            System.out.print(new String(buffer, 0, chars));
        }
    }
}

