/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.adapter.ITotalExprBindings;
import org.eclipse.birt.report.engine.adapter.ParseIndicator;
import org.eclipse.birt.report.engine.adapter.TotalExprBinding;
import org.eclipse.birt.report.engine.api.EngineException;

public final class ExpressionUtil {
    private static final String TOTAL_PREFIX = "TOTAL_COLUMN_";
    private int totalColumnSuffix = 0;

    public ITotalExprBindings prepareTotalExpressions(List exprs) throws EngineException {
        return this.prepareTotalExpressions(exprs, null);
    }

    public ITotalExprBindings prepareTotalExpressions(List exprs, String groupName) throws EngineException {
        TotalExprBinding result = new TotalExprBinding();
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < exprs.size()) {
            Object key = exprs.get(i);
            result.addColumnBindings(l);
            if (key instanceof String) {
                String expr = key == null ? null : key.toString();
                String newExpr = this.prepareTotalExpression(expr, l, groupName);
                result.addColumnBindings(l);
                result.addNewExpression(newExpr);
            } else if (key instanceof IConditionalExpression) {
                this.addConditionalExprBindings(result, (IConditionalExpression)key, l, groupName);
            } else if (key == null) {
                result.addNewExpression(null);
            }
            ++i;
        }
        return result;
    }

    public static IConditionalExpression transformConditionalExpression(IConditionalExpression ce) {
        String prefix = null;
        switch (ce.getOperator()) {
            case 14: {
                prefix = "Total.isTopN";
                break;
            }
            case 16: {
                prefix = "Total.isTopNPercent";
                break;
            }
            case 15: {
                prefix = "Total.isBottomN";
                break;
            }
            case 17: {
                prefix = "Total.isBottomNPercent";
            }
        }
        if (prefix != null) {
            ce = new ConditionalExpression(String.valueOf(prefix) + "(" + ce.getExpression().getText() + "," + ce.getOperand1().getText() + ")", 11);
        }
        return ce;
    }

    private void addConditionalExprBindings(TotalExprBinding result, IConditionalExpression key, List bindings, String groupName) throws EngineException {
        try {
            IConditionalExpression ce = key;
            if (groupName != null) {
                ce.setGroupName(groupName);
            }
            String bindingName = TOTAL_PREFIX + this.totalColumnSuffix;
            ++this.totalColumnSuffix;
            Binding columnBinding = new Binding(bindingName, (IBaseExpression)ce);
            if (groupName != null) {
                columnBinding.addAggregateOn(groupName);
            }
            ArrayList<Binding> allColumnBindings = new ArrayList<Binding>();
            allColumnBindings.add(columnBinding);
            result.addColumnBindings(allColumnBindings);
            result.addNewExpression(org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)bindingName));
        }
        catch (DataException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
    }

    private String prepareTotalExpression(String oldExpression, List columnBindings, String groupName) throws EngineException {
        block11: {
            if (oldExpression != null) break block11;
            return null;
        }
        try {
            char[] chars = oldExpression.toCharArray();
            if (chars.length < 8) {
                return oldExpression;
            }
            ParseIndicator indicator = new ParseIndicator(0, 0, false, false, true, true);
            int i = 0;
            while (i < chars.length) {
                if ((i = (indicator = ExpressionUtil.getParseIndicator(chars, i, indicator.omitNextQuote(), indicator.getCandidateKey1(), indicator.getCandidateKey2())).getNewIndex()) >= indicator.getRetrieveSize() + 6 && indicator.isCandidateKey() && chars[i - indicator.getRetrieveSize() - 6] == 'T' && chars[i - indicator.getRetrieveSize() - 5] == 'o' && chars[i - indicator.getRetrieveSize() - 4] == 't' && chars[i - indicator.getRetrieveSize() - 3] == 'a' && chars[i - indicator.getRetrieveSize() - 2] == 'l' && chars[i - indicator.getRetrieveSize() - 1] == '.' && (i - indicator.getRetrieveSize() - 7 <= 0 || ExpressionUtil.isValidProceeding(chars[i - indicator.getRetrieveSize() - 7]))) {
                    String firstPart = oldExpression.substring(0, i - indicator.getRetrieveSize() - 6);
                    int startIndex = i - indicator.getRetrieveSize() - 6;
                    i = ExpressionUtil.advanceToNextValidEncloser(chars, i);
                    String secondPart = "";
                    String name = "";
                    String expr = "";
                    if (i < chars.length) {
                        int endIndex = i + 1;
                        expr = oldExpression.substring(startIndex, endIndex);
                        secondPart = this.prepareTotalExpression(oldExpression.substring(i + 1 - indicator.getRetrieveSize()), columnBindings, groupName);
                    } else {
                        expr = oldExpression.substring(startIndex);
                    }
                    boolean shouldAddToList = true;
                    int j = 0;
                    while (j < columnBindings.size()) {
                        IBaseExpression expression = ((IBinding)columnBindings.get(j)).getExpression();
                        if (expression instanceof IScriptExpression && oldExpression.equals(((IScriptExpression)expression).getText())) {
                            shouldAddToList = false;
                            name = ((IBinding)columnBindings.get(j)).getBindingName();
                            break;
                        }
                        ++j;
                    }
                    if (shouldAddToList) {
                        name = TOTAL_PREFIX + this.totalColumnSuffix;
                        ++this.totalColumnSuffix;
                        ScriptExpression se = new ScriptExpression(expr);
                        se.setGroupName(groupName);
                        Binding columnBinding = new Binding(name, (IBaseExpression)se);
                        columnBindings.add(columnBinding);
                    }
                    String newExpression = String.valueOf(firstPart) + org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)name) + secondPart;
                    return newExpression;
                }
                ++i;
            }
            return oldExpression;
        }
        catch (DataException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
    }

    private static int advanceToNextValidEncloser(char[] chars, int i) {
        boolean isTotalConstants = true;
        int numberOfOpenBracket = 0;
        while (i < chars.length) {
            ParseIndicator pid = ExpressionUtil.getParseIndicator(chars, i, false, true, true);
            i = pid.getNewIndex();
            if (pid.isCandidateKey() && chars[i] == '(') {
                isTotalConstants = false;
                ++numberOfOpenBracket;
            }
            if (isTotalConstants) {
                if (ExpressionUtil.isValidProceeding(chars[i])) break;
                ++i;
                continue;
            }
            if (chars[i] != ')') {
                ++i;
                continue;
            }
            if (chars[i] == ')') {
                --numberOfOpenBracket;
            }
            if (numberOfOpenBracket == 0) break;
            ++i;
        }
        if (isTotalConstants) {
            --i;
        }
        return i;
    }

    private static ParseIndicator getParseIndicator(char[] chars, int i, boolean omitNextQuote, boolean candidateKey1, boolean candidateKey2) {
        int retrieveSize = 0;
        if (chars[i] == '/') {
            if (i > 0 && chars[i - 1] == '/') {
                ++retrieveSize;
                while (i < chars.length - 2) {
                    ++retrieveSize;
                    if (chars[++i] == '\n') break;
                }
                ++retrieveSize;
                ++i;
            }
        } else if (chars[i] == '*' && i > 0 && chars[i - 1] == '/') {
            ++i;
            retrieveSize += 2;
            while (i < chars.length - 2) {
                ++retrieveSize;
                if (chars[++i - 1] == '*' && chars[i] == '/') break;
            }
            ++retrieveSize;
            ++i;
        }
        if (!omitNextQuote && chars[i] == '\"') {
            boolean bl = candidateKey1 = !candidateKey1;
            if (candidateKey1) {
                candidateKey2 = true;
            }
        }
        if (!omitNextQuote && chars[i] == '\'') {
            boolean bl = candidateKey2 = !candidateKey2;
            if (candidateKey2) {
                candidateKey1 = true;
            }
        }
        omitNextQuote = chars[i] == '\\';
        return new ParseIndicator(retrieveSize, i, candidateKey1, omitNextQuote, candidateKey1, candidateKey2);
    }

    private static boolean isValidProceeding(char operator) {
        return !(operator >= 'A' && operator <= 'Z' || operator >= 'a' && operator <= 'z') && operator != '_';
    }

    private int toDteFilterOperator(String modelOpr) {
        if (modelOpr.equals("eq")) {
            return 1;
        }
        if (modelOpr.equals("ne")) {
            return 2;
        }
        if (modelOpr.equals("lt")) {
            return 3;
        }
        if (modelOpr.equals("le")) {
            return 4;
        }
        if (modelOpr.equals("ge")) {
            return 5;
        }
        if (modelOpr.equals("gt")) {
            return 6;
        }
        if (modelOpr.equals("between")) {
            return 7;
        }
        if (modelOpr.equals("not-between")) {
            return 8;
        }
        if (modelOpr.equals("is-null")) {
            return 9;
        }
        if (modelOpr.equals("is-not-null")) {
            return 10;
        }
        if (modelOpr.equals("is-true")) {
            return 11;
        }
        if (modelOpr.equals("is-false")) {
            return 12;
        }
        if (modelOpr.equals("like")) {
            return 13;
        }
        if (modelOpr.equals("top-n")) {
            return 14;
        }
        if (modelOpr.equals("bottom-n")) {
            return 15;
        }
        if (modelOpr.equals("top-percent")) {
            return 16;
        }
        if (modelOpr.equals("bottom-percent")) {
            return 17;
        }
        if (modelOpr.equals("not-like")) {
            return 20;
        }
        if (modelOpr.equals("not-match")) {
            return 21;
        }
        return 0;
    }

    public IConditionalExpression createConditionalExpression(String testExpression, String operator, String value1, String value2) {
        ConditionalExpression expression = new ConditionalExpression(testExpression, this.toDteFilterOperator(operator), value1, value2);
        return ExpressionUtil.transformConditionalExpression((IConditionalExpression)expression);
    }
}

