/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.JoinCondition;
import org.eclipse.birt.data.engine.api.querydefn.JointDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.script.IBaseDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DataSetScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataSourceScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptDataSetScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptDataSourceScriptExecutor;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JoinConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.mozilla.javascript.Scriptable;

public class ModelDteApiAdapter {
    private ExecutionContext context;
    private Scriptable jsScope;
    private DataRequestSession dteSession;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static ModelDteApiAdapter getInstance() {
        return new ModelDteApiAdapter();
    }

    public IBaseDataSourceDesign createDataSourceDesign(DataSourceHandle dataSource, ExecutionContext context) throws EngineException {
        try {
            ModelDteApiAdapter tmpAdaptor = new ModelDteApiAdapter(context, null);
            return tmpAdaptor.createDataSourceDesign(dataSource);
        }
        catch (BirtException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
    }

    public IBaseDataSetDesign createDataSetDesign(DataSetHandle dataSet, ExecutionContext context) throws EngineException {
        try {
            ModelDteApiAdapter tmpAdaptor = new ModelDteApiAdapter(context, null);
            return tmpAdaptor.createDataSetDesign(dataSet);
        }
        catch (BirtException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
    }

    public ModelDteApiAdapter() {
    }

    public ModelDteApiAdapter(ExecutionContext context, Scriptable jsScope) {
        this.context = context;
        this.jsScope = jsScope;
    }

    public IBaseDataSourceDesign createDataSourceDesign(DataSourceHandle dataSource) throws BirtException {
        if (dataSource instanceof OdaDataSourceHandle) {
            return this.newOdaDataSource((OdaDataSourceHandle)dataSource);
        }
        if (dataSource instanceof ScriptDataSourceHandle) {
            return this.newScriptDataSource((ScriptDataSourceHandle)dataSource);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public IBaseDataSetDesign createDataSetDesign(DataSetHandle dataSet) throws BirtException {
        if (dataSet instanceof OdaDataSetHandle) {
            return this.newOdaDataSet((OdaDataSetHandle)dataSet, this.context);
        }
        if (dataSet instanceof ScriptDataSetHandle) {
            return this.newScriptDataSet((ScriptDataSetHandle)dataSet, this.context);
        }
        if (dataSet instanceof JointDataSetHandle) {
            return this.newJointDataSet((JointDataSetHandle)dataSet, this.context);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void defineDataSet(DataSetHandle dataSet, DataRequestSession dteSession) throws BirtException {
        if (dataSet == null || dteSession == null) {
            return;
        }
        this.dteSession = dteSession;
        DataSourceHandle dataSource = dataSet.getDataSource();
        if (dataSource != null) {
            this.doDefineDataSource(dataSource);
        }
        this.doDefineDataSet(dataSet);
    }

    private void doDefineDataSource(DataSourceHandle dataSource) throws BirtException {
        this.dteSession.defineDataSource(this.createDataSourceDesign(dataSource));
    }

    private void doDefineDataSet(DataSetHandle dataSet) throws BirtException {
        if (dataSet instanceof JointDataSetHandle) {
            JointDataSetHandle jointDataSet = (JointDataSetHandle)dataSet;
            Iterator iter = jointDataSet.dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle childDataSet = (DataSetHandle)iter.next();
                if (childDataSet == null) continue;
                DataSourceHandle childDataSource = childDataSet.getDataSource();
                if (childDataSource != null) {
                    this.doDefineDataSource(childDataSource);
                }
                this.doDefineDataSet(childDataSet);
            }
        }
        this.dteSession.defineDataSet(this.createDataSetDesign(dataSet));
    }

    private IJointDataSetDesign newJointDataSet(JointDataSetHandle handle, ExecutionContext context2) throws BirtException {
        Iterator it = handle.joinConditionsIterator();
        ArrayList<JoinCondition> joinConditions = new ArrayList<JoinCondition>();
        JoinConditionHandle jc = null;
        while (it.hasNext()) {
            jc = (JoinConditionHandle)it.next();
            joinConditions.add(new JoinCondition((IScriptExpression)new ScriptExpression(jc.getLeftExpression()), (IScriptExpression)new ScriptExpression(jc.getRightExpression()), this.toDteJoinOperator(jc.getOperator())));
        }
        int joinType = this.toDteJoinType(jc.getJoinType());
        DataSetScriptExecutor eventHandler = new DataSetScriptExecutor((DataSetHandle)handle, this.context);
        JointDataSetDesign dteDataSet = new JointDataSetDesign(handle.getQualifiedName(), jc.getLeftDataSet(), jc.getRightDataSet(), joinType, joinConditions);
        dteDataSet.setEventHandler((IBaseDataSetEventHandler)eventHandler);
        this.adaptBaseDataSet((DataSetHandle)handle, (BaseDataSetDesign)dteDataSet);
        return dteDataSet;
    }

    private int toDteJoinOperator(String operator) {
        if (operator.equals("eq")) {
            return 1;
        }
        return -1;
    }

    private int toDteJoinType(String joinType) {
        if (joinType.equals("inner")) {
            return 0;
        }
        if (joinType.equals("left-out")) {
            return 1;
        }
        if (joinType.equals("right-out")) {
            return 2;
        }
        if (joinType.equals("full-out")) {
            return 3;
        }
        return -1;
    }

    String evaluatePropertyBindingExpr(String expr) throws BirtException {
        Object result = JavascriptEvalUtil.evaluateScript(null, (Scriptable)this.jsScope, (String)expr, (String)"property binding", (int)0);
        return result == null ? null : result.toString();
    }

    IOdaDataSourceDesign newOdaDataSource(OdaDataSourceHandle source) throws BirtException {
        Iterator elmtIter;
        OdaDataSourceDesign dteSource = new OdaDataSourceDesign(source.getQualifiedName());
        DataSourceScriptExecutor eventHandler = new DataSourceScriptExecutor((DataSourceHandle)source, this.context);
        dteSource.setEventHandler((IBaseDataSourceEventHandler)eventHandler);
        this.adaptBaseDataSource((DataSourceHandle)source, (BaseDataSourceDesign)dteSource);
        String driverName = source.getExtensionID();
        if (driverName == null || driverName.length() == 0) {
            throw new EngineException("Missing extenion id in data source definition, " + source.getName());
        }
        dteSource.setExtensionID(driverName);
        Map staticProps = this.getExtensionProperties((ReportElementHandle)source, source.getExtensionPropertyDefinitionList());
        if (staticProps != null && !staticProps.isEmpty()) {
            Iterator propNamesItr = staticProps.keySet().iterator();
            while (propNamesItr.hasNext()) {
                String propName = (String)propNamesItr.next();
                if (!$assertionsDisabled && propName == null) {
                    throw new AssertionError();
                }
                String bindingExpr = source.getPropertyBinding(propName);
                String propValue = this.needPropertyBinding() && bindingExpr != null && bindingExpr.length() > 0 ? this.evaluatePropertyBindingExpr(bindingExpr) : (String)staticProps.get(propName);
                dteSource.addPublicProperty(propName, propValue);
            }
        }
        if ((elmtIter = source.privateDriverPropertiesIterator()) != null) {
            while (elmtIter.hasNext()) {
                ExtendedPropertyHandle modelProp = (ExtendedPropertyHandle)elmtIter.next();
                dteSource.addPrivateProperty(modelProp.getName(), modelProp.getValue());
            }
        }
        this.addPropertyConfigurationId(dteSource);
        return dteSource;
    }

    private void addPropertyConfigurationId(OdaDataSourceDesign dteSource) throws BirtException {
        String configIdValue = String.valueOf(dteSource.getExtensionID()) + "_" + dteSource.getName();
        dteSource.addPublicProperty("OdaPropertyConfigId", configIdValue);
    }

    IScriptDataSourceDesign newScriptDataSource(ScriptDataSourceHandle source) {
        ScriptDataSourceDesign dteSource = new ScriptDataSourceDesign(source.getQualifiedName());
        ScriptDataSourceScriptExecutor eventHandler = new ScriptDataSourceScriptExecutor(source, this.context);
        dteSource.setEventHandler((IBaseDataSourceEventHandler)eventHandler);
        this.adaptBaseDataSource((DataSourceHandle)source, (BaseDataSourceDesign)dteSource);
        dteSource.setOpenScript(source.getOpen());
        dteSource.setCloseScript(source.getClose());
        return dteSource;
    }

    void adaptBaseDataSource(DataSourceHandle source, BaseDataSourceDesign dest) {
        dest.setBeforeOpenScript(source.getBeforeOpen());
        dest.setAfterOpenScript(source.getAfterOpen());
        dest.setBeforeCloseScript(source.getBeforeClose());
        dest.setAfterCloseScript(source.getAfterClose());
    }

    IOdaDataSetDesign newOdaDataSet(OdaDataSetHandle modelDataSet, ExecutionContext context) throws BirtException {
        Iterator elmtIter;
        OdaDataSetDesign dteDataSet = new OdaDataSetDesign(modelDataSet.getQualifiedName());
        DataSetScriptExecutor eventHandler = new DataSetScriptExecutor((DataSetHandle)modelDataSet, context);
        dteDataSet.setEventHandler((IBaseDataSetEventHandler)eventHandler);
        this.adaptBaseDataSet((DataSetHandle)modelDataSet, (BaseDataSetDesign)dteDataSet);
        String queryTextBinding = modelDataSet.getPropertyBinding("queryText");
        if (this.needPropertyBinding() && queryTextBinding != null && queryTextBinding.length() > 0) {
            dteDataSet.setQueryText(this.evaluatePropertyBindingExpr(queryTextBinding));
        } else {
            dteDataSet.setQueryText(modelDataSet.getQueryText());
        }
        dteDataSet.setExtensionID(modelDataSet.getExtensionID());
        dteDataSet.setPrimaryResultSetName(modelDataSet.getResultSetName());
        Map staticProps = this.getExtensionProperties((ReportElementHandle)modelDataSet, modelDataSet.getExtensionPropertyDefinitionList());
        if (staticProps != null && !staticProps.isEmpty()) {
            Iterator propNamesItr = staticProps.keySet().iterator();
            while (propNamesItr.hasNext()) {
                String propName = (String)propNamesItr.next();
                if (!$assertionsDisabled && propName == null) {
                    throw new AssertionError();
                }
                String bindingExpr = modelDataSet.getPropertyBinding(propName);
                String propValue = this.needPropertyBinding() && bindingExpr != null && bindingExpr.length() > 0 ? this.evaluatePropertyBindingExpr(bindingExpr) : (String)staticProps.get(propName);
                dteDataSet.addPublicProperty(propName, propValue);
            }
        }
        if ((elmtIter = modelDataSet.privateDriverPropertiesIterator()) != null) {
            while (elmtIter.hasNext()) {
                ExtendedPropertyHandle modelProp = (ExtendedPropertyHandle)elmtIter.next();
                dteDataSet.addPrivateProperty(modelProp.getName(), modelProp.getValue());
            }
        }
        return dteDataSet;
    }

    IScriptDataSetDesign newScriptDataSet(ScriptDataSetHandle modelDataSet, ExecutionContext context) throws BirtException {
        ScriptDataSetDesign dteDataSet = new ScriptDataSetDesign(modelDataSet.getQualifiedName());
        ScriptDataSetScriptExecutor eventHandler = new ScriptDataSetScriptExecutor(modelDataSet, context);
        dteDataSet.setEventHandler((IBaseDataSetEventHandler)eventHandler);
        this.adaptBaseDataSet((DataSetHandle)modelDataSet, (BaseDataSetDesign)dteDataSet);
        dteDataSet.setOpenScript(modelDataSet.getOpen());
        dteDataSet.setFetchScript(modelDataSet.getFetch());
        dteDataSet.setCloseScript(modelDataSet.getClose());
        dteDataSet.setDescribeScript(modelDataSet.getDescribe());
        return dteDataSet;
    }

    void adaptBaseDataSet(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) throws BirtException {
        if (!(modelDataSet instanceof JointDataSetHandle) && modelDataSet.getDataSource() == null) {
            throw new EngineException("The data source of this data set can not be null.");
        }
        if (!(modelDataSet instanceof JointDataSetHandle)) {
            dteDataSet.setDataSource(modelDataSet.getDataSource().getQualifiedName());
            dteDataSet.setBeforeOpenScript(modelDataSet.getBeforeOpen());
            dteDataSet.setAfterOpenScript(modelDataSet.getAfterOpen());
            dteDataSet.setOnFetchScript(modelDataSet.getOnFetch());
            dteDataSet.setBeforeCloseScript(modelDataSet.getBeforeClose());
            dteDataSet.setAfterCloseScript(modelDataSet.getAfterClose());
            dteDataSet.setCacheRowCount(modelDataSet.getCachedRowCount());
        }
        this.populateParameter(modelDataSet, dteDataSet);
        this.populateComputedColumn(modelDataSet, dteDataSet);
        this.populateFilter(modelDataSet, dteDataSet);
        dteDataSet.setRowFetchLimit(modelDataSet.getRowFetchLimit());
        this.mergeHints(modelDataSet, dteDataSet);
    }

    private Iterator populateParameter(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        HashMap<String, String> paramBindingCandidates = new HashMap<String, String>();
        Iterator elmtIter = modelDataSet.parametersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                DataSetParameterHandle modelParam = (DataSetParameterHandle)elmtIter.next();
                if (modelParam.isInput()) {
                    String defaultValueExpr = null;
                    defaultValueExpr = modelParam instanceof OdaDataSetParameterHandle && ((OdaDataSetParameterHandle)modelParam).getParamName() != null ? ExpressionUtil.createJSParameterExpression((String)((OdaDataSetParameterHandle)modelParam).getParamName()) : modelParam.getDefaultValue();
                    if (defaultValueExpr == null) continue;
                    dteDataSet.addParameter(this.newParam(modelParam));
                    paramBindingCandidates.put(modelParam.getName(), defaultValueExpr);
                    continue;
                }
                dteDataSet.addParameter(this.newParam(modelParam));
            }
        }
        if ((elmtIter = modelDataSet.paramBindingsIterator()) != null) {
            while (elmtIter.hasNext()) {
                ParamBindingHandle modelParamBinding = (ParamBindingHandle)elmtIter.next();
                paramBindingCandidates.put(modelParamBinding.getParamName(), modelParamBinding.getExpression());
            }
        }
        if (paramBindingCandidates.size() > 0) {
            elmtIter = paramBindingCandidates.keySet().iterator();
            while (elmtIter.hasNext()) {
                Object paramName = elmtIter.next();
                if (!($assertionsDisabled || paramName != null && paramName instanceof String)) {
                    throw new AssertionError();
                }
                String expression = (String)paramBindingCandidates.get(paramName);
                dteDataSet.addInputParamBinding(this.newInputParamBinding((String)paramName, expression));
            }
        }
        return elmtIter;
    }

    private void populateComputedColumn(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) throws EngineException {
        Iterator elmtIter = modelDataSet.computedColumnsIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                ComputedColumnHandle modelCmptdColumn = (ComputedColumnHandle)elmtIter.next();
                IComputedColumn dteCmptdColumn = this.newComputedColumn(modelCmptdColumn);
                dteDataSet.addComputedColumn(dteCmptdColumn);
            }
        }
    }

    private void populateFilter(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        Iterator elmtIter = modelDataSet.filtersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                FilterConditionHandle modelFilter = (FilterConditionHandle)elmtIter.next();
                IFilterDefinition dteFilter = this.newFilter(modelFilter);
                dteDataSet.addFilter(dteFilter);
            }
        }
    }

    private void mergeHints(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        OdaResultSetColumnHandle modelColumn;
        Iterator elmtIter = null;
        if (modelDataSet instanceof OdaDataSetHandle && (elmtIter = modelDataSet.resultSetIterator()) != null) {
            while (elmtIter.hasNext()) {
                modelColumn = (OdaResultSetColumnHandle)elmtIter.next();
                if (modelColumn.getColumnName().equals(modelColumn.getNativeName())) continue;
                dteDataSet.addResultSetHint(this.newColumnDefn((ResultSetColumnHandle)modelColumn));
            }
        }
        if ((elmtIter = modelDataSet.resultSetHintsIterator()) != null) {
            while (elmtIter.hasNext()) {
                modelColumn = (ResultSetColumnHandle)elmtIter.next();
                dteDataSet.addResultSetHint(this.newColumnDefn((ResultSetColumnHandle)modelColumn));
            }
        }
        if ((elmtIter = modelDataSet.columnHintsIterator()) != null) {
            List columnDefns = dteDataSet.getResultSetHints();
            while (elmtIter.hasNext()) {
                ColumnHintHandle modelColumnHint = (ColumnHintHandle)elmtIter.next();
                ColumnDefinition existDefn = this.findColumnDefn(columnDefns, modelColumnHint.getColumnName());
                if (existDefn != null) {
                    this.updateColumnDefn(existDefn, modelColumnHint);
                    continue;
                }
                dteDataSet.addResultSetHint(this.newColumnDefn(modelColumnHint));
            }
        }
    }

    IParameterDefinition newParam(DataSetParameterHandle modelParam) {
        ParameterDefinition dteParam = new ParameterDefinition();
        dteParam.setName(modelParam.getName());
        if (modelParam.getPosition() != null) {
            dteParam.setPosition(modelParam.getPosition().intValue());
        }
        if (modelParam.getNativeDataType() != null) {
            dteParam.setNativeType(modelParam.getNativeDataType().intValue());
        }
        dteParam.setType(ModelDteApiAdapter.toDteDataType(modelParam.getDataType()));
        dteParam.setInputMode(modelParam.isInput());
        dteParam.setOutputMode(modelParam.isOutput());
        dteParam.setNullable(modelParam.allowNull());
        dteParam.setInputOptional(modelParam.isOptional());
        dteParam.setDefaultInputValue(modelParam.getDefaultValue());
        return dteParam;
    }

    IInputParameterBinding newInputParamBinding(ParamBindingHandle modelInputParamBndg) {
        return this.newInputParamBinding(modelInputParamBndg.getParamName(), modelInputParamBndg.getExpression());
    }

    private IInputParameterBinding newInputParamBinding(String paramName, String paramValue) {
        if (paramValue == null) {
            return null;
        }
        ScriptExpression paramValueExpr = new ScriptExpression(paramValue);
        return new InputParameterBinding(paramName, (IBaseExpression)paramValueExpr);
    }

    IComputedColumn newComputedColumn(ComputedColumnHandle modelCmptdColumn) throws EngineException {
        if (modelCmptdColumn.getExpression() == null && modelCmptdColumn.getAggregateFunction() == null) {
            throw new EngineException("Error.MissingComputedColumnExpression", modelCmptdColumn.getName());
        }
        ArrayList<ScriptExpression> argumentList = new ArrayList<ScriptExpression>();
        Iterator argumentIter = modelCmptdColumn.argumentsIterator();
        while (argumentIter.hasNext()) {
            argumentList.add(new ScriptExpression(((AggregationArgumentHandle)argumentIter.next()).getValue()));
        }
        return new ComputedColumn(modelCmptdColumn.getName(), modelCmptdColumn.getExpression(), ModelDteApiAdapter.toDteDataType(modelCmptdColumn.getDataType()), modelCmptdColumn.getAggregateFunction(), (IScriptExpression)(modelCmptdColumn.getFilterExpression() == null ? null : new ScriptExpression(modelCmptdColumn.getFilterExpression())), argumentList);
    }

    IFilterDefinition newFilter(FilterConditionHandle modelFilter) {
        String filterExpr = modelFilter.getExpr();
        if (filterExpr == null || filterExpr.length() == 0) {
            return null;
        }
        String filterOpr = modelFilter.getOperator();
        if (filterOpr == null || filterOpr.length() == 0) {
            return new FilterDefinition((IBaseExpression)new ScriptExpression(filterExpr));
        }
        String column = filterExpr;
        int dteOpr = ModelDteApiAdapter.toDteFilterOperator(filterOpr);
        String operand1 = modelFilter.getValue1();
        String operand2 = modelFilter.getValue2();
        return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operand1, operand2));
    }

    private IColumnDefinition newColumnDefn(ResultSetColumnHandle modelColumn) {
        ColumnDefinition newColumn = new ColumnDefinition(modelColumn.getColumnName());
        if (modelColumn.getPosition() != null) {
            newColumn.setColumnPosition(modelColumn.getPosition().intValue());
        }
        if (modelColumn.getNativeDataType() != null) {
            newColumn.setNativeDataType(modelColumn.getNativeDataType().intValue());
        }
        newColumn.setDataType(ModelDteApiAdapter.toDteDataType(modelColumn.getDataType()));
        return newColumn;
    }

    private void updateColumnDefn(ColumnDefinition dteColumn, ColumnHintHandle modelColumnHint) {
        String searchConstant;
        if (!$assertionsDisabled && !dteColumn.getColumnName().equals(modelColumnHint.getColumnName())) {
            throw new AssertionError();
        }
        dteColumn.setAlias(modelColumnHint.getAlias());
        String exportConstant = modelColumnHint.getExport();
        if (exportConstant != null) {
            int exportHint = 1;
            if (exportConstant.equals("if-realized")) {
                exportHint = 2;
            } else if (exportConstant.equals("always")) {
                exportHint = 3;
            } else if (!$assertionsDisabled && !exportConstant.equals("none")) {
                throw new AssertionError();
            }
            dteColumn.setExportHint(exportHint);
        }
        if ((searchConstant = modelColumnHint.getSearching()) != null) {
            int searchHint = 3;
            if (searchConstant.equals("indexed")) {
                searchHint = 2;
            } else if (searchConstant.equals("any")) {
                searchHint = 1;
            } else if (!$assertionsDisabled && !searchConstant.equals("none")) {
                throw new AssertionError();
            }
            dteColumn.setSearchHint(searchHint);
        }
    }

    private IColumnDefinition newColumnDefn(ColumnHintHandle modelColumnHint) {
        ColumnDefinition newColumn = new ColumnDefinition(modelColumnHint.getColumnName());
        this.updateColumnDefn(newColumn, modelColumnHint);
        return newColumn;
    }

    /*
     * Unable to fully structure code
     */
    private ColumnDefinition findColumnDefn(List columnDefns, String columnName) {
        if (!ModelDteApiAdapter.$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        if (columnDefns == null) {
            return null;
        }
        iter = columnDefns.iterator();
        if (iter != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            column = (ColumnDefinition)iter.next();
            if (!columnName.equals(column.getColumnName())) continue;
            return column;
lbl11:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl12:
        // 1 sources

        return null;
    }

    public static int toDteDataType(String modelDataType) {
        if (modelDataType == null) {
            return -1;
        }
        if (modelDataType.equals("any")) {
            return 0;
        }
        if (modelDataType.equals("integer")) {
            return 2;
        }
        if (modelDataType.equals("string")) {
            return 5;
        }
        if (modelDataType.equals("date-time")) {
            return 6;
        }
        if (modelDataType.equals("date")) {
            return 9;
        }
        if (modelDataType.equals("time")) {
            return 10;
        }
        if (modelDataType.equals("decimal")) {
            return 4;
        }
        if (modelDataType.equals("float")) {
            return 3;
        }
        if (modelDataType.equals("boolean")) {
            return 1;
        }
        return -1;
    }

    public static int toDteFilterOperator(String modelOpr) {
        if (modelOpr.equals("eq")) {
            return 1;
        }
        if (modelOpr.equals("ne")) {
            return 2;
        }
        if (modelOpr.equals("lt")) {
            return 3;
        }
        if (modelOpr.equals("le")) {
            return 4;
        }
        if (modelOpr.equals("ge")) {
            return 5;
        }
        if (modelOpr.equals("gt")) {
            return 6;
        }
        if (modelOpr.equals("between")) {
            return 7;
        }
        if (modelOpr.equals("not-between")) {
            return 8;
        }
        if (modelOpr.equals("is-null")) {
            return 9;
        }
        if (modelOpr.equals("is-not-null")) {
            return 10;
        }
        if (modelOpr.equals("is-true")) {
            return 11;
        }
        if (modelOpr.equals("is-false")) {
            return 12;
        }
        if (modelOpr.equals("like")) {
            return 13;
        }
        if (modelOpr.equals("top-n")) {
            return 14;
        }
        if (modelOpr.equals("bottom-n")) {
            return 15;
        }
        if (modelOpr.equals("top-percent")) {
            return 16;
        }
        if (modelOpr.equals("bottom-percent")) {
            return 17;
        }
        if (modelOpr.equals("match")) {
            return 19;
        }
        if (modelOpr.equals("not-like")) {
            return 20;
        }
        if (modelOpr.equals("not-match")) {
            return 21;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    private Map getExtensionProperties(ReportElementHandle dataHandle, List driverPropList) {
        if (driverPropList == null || driverPropList.isEmpty()) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Iterator elmtIter = driverPropList.iterator();
        while (elmtIter.hasNext()) {
            IPropertyDefn modelExtProp = (IPropertyDefn)elmtIter.next();
            String propName = modelExtProp.getName();
            if (!($assertionsDisabled || propName != null && propName.length() > 0)) {
                throw new AssertionError();
            }
            Object propValueObj = dataHandle.getProperty(modelExtProp.getName());
            String propValue = propValueObj == null ? null : propValueObj.toString();
            properties.put(propName, propValue);
        }
        return properties;
    }

    private boolean needPropertyBinding() {
        return this.context != null && this.jsScope != null;
    }
}

