/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchive;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.AbstractRunTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.emitter.ReportEmitterExecutor;
import org.eclipse.birt.report.engine.presentation.ReportDocumentBuilder;

public class RunTask
extends AbstractRunTask
implements IRunTask {
    private String documentName;
    private IDocArchiveWriter archive;
    private ReportDocumentWriter writer;
    private IPageHandler pageHandler;
    private ReportDocumentBuilder documentBuilder;

    public RunTask(IReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 1);
        this.executionContext.setFactoryMode(true);
        this.executionContext.setPresentationMode(false);
    }

    public void setPageHandler(IPageHandler callback) {
        this.pageHandler = callback;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String reportDocName) throws EngineException {
        try {
            this.changeStatusToRunning();
            if (reportDocName == null) throw new EngineException("Report document name is not specified when running a report.");
            if (reportDocName.length() == 0) {
                throw new EngineException("Report document name is not specified when running a report.");
            }
            this.documentName = reportDocName;
            this.doRun();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.changeStatusToStopped();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.changeStatusToStopped();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IDocArchiveWriter archive) throws EngineException {
        try {
            this.changeStatusToRunning();
            if (archive == null) {
                throw new EngineException("Report archive is not specified when running a report.");
            }
            this.archive = archive;
            this.doRun();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.changeStatusToStopped();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.changeStatusToStopped();
    }

    private void openArchive() throws IOException {
        File file = new File(this.documentName);
        this.archive = file.exists() ? (file.isDirectory() ? new FolderArchiveWriter(this.documentName) : new FileArchiveWriter(this.documentName)) : (this.documentName.endsWith("\\") || this.documentName.endsWith("/") ? new FolderArchiveWriter(this.documentName) : new FileArchiveWriter(this.documentName));
    }

    private void openReportDocument() throws EngineException {
        try {
            if (this.archive == null) {
                this.openArchive();
            }
            this.writer = new ReportDocumentWriter(this.engine, this.archive);
            this.executionContext.setReportDocWriter(this.writer);
        }
        catch (IOException ex) {
            throw new EngineException("Can not open the report archive.", ex);
        }
    }

    private void closeReportDocument() {
        this.writer.close();
        this.writer = null;
        this.archive = null;
        this.documentName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() throws EngineException {
        if (!this.validateParameters()) {
            throw new EngineException("Error.InvalidParameter");
        }
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.openReportDocument();
        try {
            try {
                ReportRunnable report = this.executionContext.getRunnable();
                this.writer.saveDesign(report);
                this.writer.saveParamters(this.inputValues);
                this.executionContext.openDataEngine();
                RunTask runTask = this;
                synchronized (runTask) {
                    if (!this.executionContext.isCanceled()) {
                        this.documentBuilder = new ReportDocumentBuilder(this.executionContext, this.writer);
                    }
                }
                if (this.documentBuilder != null) {
                    if (this.pageHandler != null) {
                        this.documentBuilder.setPageHandler(this.pageHandler);
                    }
                    IContentEmitter emitter = this.documentBuilder.getContentEmitter();
                    IReportExecutor executor = new ReportExecutor(this.executionContext);
                    executor = new ReportEmitterExecutor(executor, emitter);
                    executor = new SuppressDuplciateReportExecutor(executor);
                    this.executionContext.setExecutor(executor);
                    this.initializeContentEmitter(emitter, executor);
                    this.documentBuilder.build();
                }
                this.executionContext.closeDataEngine();
                this.writer.savePersistentObjects(this.executionContext.getGlobalBeans());
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
                throw new EngineException("Error happened while running the report", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error happened while running the report", t);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.documentBuilder = null;
            this.closeReportDocument();
            this.closeFactory();
            throw throwable;
        }
        {
            Object var4_9 = null;
            this.documentBuilder = null;
            this.closeReportDocument();
        }
        this.closeFactory();
    }

    public void close() {
        super.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(FolderArchive fArchive) throws EngineException {
        try {
            this.changeStatusToRunning();
            this.setDataSource((IDocArchiveReader)fArchive);
            this.run((IDocArchiveWriter)fArchive);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.changeStatusToStopped();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.changeStatusToStopped();
    }

    public void cancel() {
        super.cancel();
        if (this.documentBuilder != null) {
            this.documentBuilder.cancel();
        }
    }
}

