/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPrefixMapping;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IXPathExpression;

public class XPathExpression
implements IXPathExpression {
    private String expression;
    private List<IPrefixMapping> prefixMappings = new ArrayList<IPrefixMapping>();
    private URI dialect;

    public XPathExpression(URI dialect) {
        this.dialect = dialect;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String xpathExpression) {
        this.expression = xpathExpression;
    }

    public IPrefixMapping[] getPrefixMappings() {
        return this.prefixMappings.toArray(new IPrefixMapping[this.prefixMappings.size()]);
    }

    public boolean addPrefixMapping(IPrefixMapping mapping) {
        return this.prefixMappings.add(mapping);
    }

    public int getType() {
        return 3;
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<cmdbf:xpathExpression");
        writer.write(" ");
        CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"dialect", (String)this.dialect.toString());
        writer.write(">" + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.prefixMappings);
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 1));
        writer.write(CMDBfServicesUtil.beginTagFor((String)"cmdbf:expression"));
        writer.write(this.getExpression());
        writer.write(CMDBfServicesUtil.endTagFor((String)"cmdbf:expression"));
        writer.write(ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"cmdbf:xpathExpression")) + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dialect == null ? 0 : this.dialect.hashCode());
        result = 31 * result + (this.prefixMappings == null ? 0 : this.prefixMappings.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathExpression other = (XPathExpression)obj;
        if (this.dialect == null ? other.dialect != null : !this.dialect.equals(other.dialect)) {
            return false;
        }
        if (this.prefixMappings == null ? other.prefixMappings != null : !this.prefixMappings.equals(other.prefixMappings)) {
            return false;
        }
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }

    public URI getDialect() {
        return this.dialect;
    }

    public void setDialect(URI dialectUri) {
        this.dialect = dialectUri;
    }
}

