/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.osgi.soa.core.web;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.muse.osgi.soa.core.web.ServletDescriptor;
import org.apache.muse.osgi.soa.core.web.WebAppDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class WebApp
implements HttpContext {
    public static WebAppDescriptor webAppDescriptor = null;
    private HttpService httpService;
    private ServiceReference sRef;

    public WebApp(WebAppDescriptor descriptor) {
        webAppDescriptor = descriptor;
    }

    public String getMimeType(String reqEntry) {
        return null;
    }

    public URL getResource(String name) {
        URL url = this.getClass().getResource(name);
        return url;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    public void start(BundleContext bc) throws BundleException {
        this.sRef = bc.getServiceReference("org.osgi.service.http.HttpService");
        if (this.sRef == null) {
            throw new BundleException("Failed to get HttpServiceReference");
        }
        this.httpService = (HttpService)bc.getService(this.sRef);
        if (this.httpService == null) {
            throw new BundleException("Failed to get HttpService");
        }
        try {
            WebAppDescriptor wad = webAppDescriptor;
            for (int i = 0; i < wad.servlet.length; ++i) {
                ServletDescriptor servlet = wad.servlet[i];
                this.httpService.registerServlet(wad.context + servlet.subContext, (Servlet)servlet.servlet, (Dictionary)servlet.initParameters, (HttpContext)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BundleException("Failed to register servlets");
        }
    }

    public void stop(BundleContext bc) throws BundleException {
        try {
            for (int i = 0; i < WebApp.webAppDescriptor.servlet.length; ++i) {
                ServletDescriptor servlet = WebApp.webAppDescriptor.servlet[i];
                this.httpService.unregister(WebApp.webAppDescriptor.context + servlet.subContext);
            }
            bc.ungetService(this.sRef);
            this.httpService = null;
            webAppDescriptor = null;
        }
        catch (Exception e) {
            throw new BundleException("Failed to unregister resources", (Throwable)e);
        }
    }
}

