/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.common.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.cosmos.me.management.annotations.ManagedEventConsumer;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedOperationInfo
extends MBeanOperationInfo {
    private static final long serialVersionUID = 2830134962483961246L;
    private Method method;
    private static final Annotation[] EMPTY_ANNOTATION_LIST = new Annotation[0];
    private boolean isEventConsumer = false;
    private String namespace = "";
    private Annotation[] methodAnnotations;
    private Annotation[][] parameterAnnotations;

    public Method getOperationMethod() {
        return this.method;
    }

    public boolean isEventConsumer() {
        return this.isEventConsumer;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        Annotation[] annotationArray = this.methodAnnotations;
        int n = this.methodAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation target = annotationArray[n2];
            if (target.annotationType().equals(annotation)) {
                return (T)target;
            }
            ++n2;
        }
        return null;
    }

    public ManagedOperationInfo(String description, Method method, Annotation[] methodAnnotations, Annotation[][] parameterAnnotations) throws IllegalArgumentException {
        super(description, method);
        ManagedEventConsumer eventConsumer;
        this.method = method;
        this.methodAnnotations = methodAnnotations;
        this.parameterAnnotations = parameterAnnotations;
        ManagedOperation managedOperation = this.getAnnotation(ManagedOperation.class);
        if (managedOperation != null) {
            ManagedResourceCapability capability;
            this.namespace = managedOperation.namespace();
            if ("".equals(this.namespace) && (capability = this.getAnnotation(ManagedResourceCapability.class)) != null) {
                this.namespace = capability.namespace();
            }
        }
        if ((eventConsumer = this.getAnnotation(ManagedEventConsumer.class)) != null) {
            this.isEventConsumer = true;
        }
    }

    public Annotation[] getAnnotationsForParameter(MBeanParameterInfo info) {
        MBeanParameterInfo[] parms = this.getSignature();
        if (parms == null) {
            return EMPTY_ANNOTATION_LIST;
        }
        int i = 0;
        MBeanParameterInfo[] mBeanParameterInfoArray = parms;
        int n = parms.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanParameterInfo parm = mBeanParameterInfoArray[n2];
            if (parm.equals(info)) break;
            ++i;
            ++n2;
        }
        if (i < parms.length) {
            return this.parameterAnnotations[i];
        }
        return EMPTY_ANNOTATION_LIST;
    }
}

