/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.command.LibraryReloadedEvent;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.LibraryRecord;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.eclipse.birt.report.model.util.LevelContentIterator;

public class LibraryCommand
extends AbstractElementCommand {
    static final int RELOAD_ACTION = 1;
    static final int SIMPLE_ACTION = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.LibraryCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public LibraryCommand(Module module) {
        super(module, module);
    }

    public void addLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        if (StringUtil.isBlank(namespace)) {
            namespace = StringUtil.extractFileName(libraryFileName);
        }
        if (this.module.isDuplicateNamespace(namespace)) {
            throw new LibraryException(this.module, new String[]{namespace}, "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE");
        }
        URL url = this.module.findResource(libraryFileName, 2);
        if (url != null && this.module.getLibraryByLocation(url.toString()) != null) {
            throw new LibraryException(this.module, new String[]{url.toString()}, "Error.LibraryException.LIBRARY_ALREADY_INCLUDED");
        }
        if (url != null && url.toString().equals(this.module.getLocation())) {
            throw new LibraryException(this.module, new String[]{namespace}, "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY");
        }
        this.doAddLibrary(libraryFileName, namespace, 2, null);
    }

    public void dropLibraryAndBreakExtends(Library library) throws SemanticException {
        if (!this.module.getLibraries().contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        try {
            int slotID = 0;
            while (slotID < library.getDefn().getSlotCount()) {
                if (slotID != 0) {
                    Iterator iter = library.getSlot(slotID).iterator();
                    while (iter.hasNext()) {
                        DesignElement element = (DesignElement)iter.next();
                        List derived = element.getDerived();
                        int i = 0;
                        while (i < derived.size()) {
                            DesignElement child = (DesignElement)derived.get(i);
                            if (child.getRoot() == this.getModule()) {
                                ExtendsCommand command = new ExtendsCommand(this.getModule(), child);
                                command.localizeElement();
                            }
                            ++i;
                        }
                    }
                }
                ++slotID;
            }
            LibraryRecord record = new LibraryRecord(this.module, library, false);
            this.getActivityStack().execute(record);
            String libraryFileName = library.getFileName();
            if (!$assertionsDisabled && libraryFileName == null) {
                throw new AssertionError();
            }
            this.removeIncludeLibrary(libraryFileName, library.getNamespace());
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        this.getActivityStack().commit();
    }

    public void dropLibrary(Library library) throws SemanticException {
        if (!this.module.getLibraries().contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        this.dealAllElementDecendents(library, 2);
        this.doDropLibrary(library);
    }

    private void doDropLibrary(Library library) throws SemanticException {
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        LibraryRecord record = new LibraryRecord(this.module, library, false);
        this.getActivityStack().execute(record);
        try {
            String libFileName = library.getFileName();
            if (!$assertionsDisabled && libFileName == null) {
                throw new AssertionError();
            }
            this.removeIncludeLibrary(libFileName, library.getNamespace());
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        this.getActivityStack().commit();
    }

    private Map dealElementDecendents(Module library, DesignElement parent, int actionCode) throws SemanticException {
        if (!parent.hasDerived()) {
            return Collections.EMPTY_MAP;
        }
        ArrayList allDescendents = new ArrayList();
        this.getAllDescdents(parent, allDescendents);
        HashMap<Long, Map> overriddenValues = new HashMap<Long, Map>();
        int i = 0;
        while (i < allDescendents.size()) {
            DesignElement child = (DesignElement)allDescendents.get(i);
            Module tmpModule = child.getRoot();
            if (child.hasDerived()) {
                this.dealElementDecendents(tmpModule, child, actionCode);
            }
            if (tmpModule == this.module) {
                if (actionCode == 1) {
                    Map values = this.unresolveElementDescendent(this.module, child);
                    overriddenValues.put(new Long(child.getID()), values);
                } else if (actionCode == 2) {
                    throw new LibraryException(library, new String[]{child.getHandle(this.module).getDisplayLabel()}, "Error.LibraryException.LIBRARY_HAS_DESCENDENTS");
                }
            }
            ++i;
        }
        return overriddenValues;
    }

    /*
     * Unable to fully structure code
     */
    public void reloadLibrary(String location) throws DesignFileException, SemanticException {
        library = this.module.getLibraryByLocation(location, 0x7FFFFFFF);
        if (library != null) ** GOTO lbl6
        throw new LibraryException(library, new String[]{location}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        while (library.getHost() != this.module) {
            library = (Library)library.getHost();
lbl6:
            // 2 sources

            if (library != null) continue;
        }
        if (!LibraryCommand.$assertionsDisabled && library == null) {
            throw new AssertionError();
        }
        namespace = library.getNamespace();
        includedItem = this.module.findIncludedLibrary(namespace);
        path = includedItem.getFileName();
        overriddenValues = null;
        activityStack = this.getActivityStack();
        activityStack.startSilentTrans(true);
        try {
            overriddenValues = this.dealAllElementDecendents(library, 1);
            this.doDropLibrary(library);
            this.doAddLibrary(path, namespace, 1, overriddenValues);
        }
        catch (SemanticException e) {
            activityStack.rollback();
            throw e;
        }
        catch (DesignFileException e) {
            activityStack.rollback();
            throw e;
        }
        url = this.module.findResource(path, 2);
        lib = null;
        if (url != null) {
            lib = this.module.getLibraryByLocation(url.toExternalForm());
        }
        this.doPostReloadAction(lib);
    }

    public void reloadLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        if (StringUtil.isBlank(namespace)) {
            namespace = StringUtil.extractFileName(libraryFileName);
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startSilentTrans(true);
        try {
            this.doAddLibrary(libraryFileName, namespace, 1, null);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        catch (DesignFileException e) {
            stack.rollback();
            throw e;
        }
        Library lib = this.module.getLibraryWithNamespace(namespace);
        this.doPostReloadAction(lib);
    }

    private void doPostReloadAction(Library lib) {
        LibraryReloadedEvent event = new LibraryReloadedEvent(this.module, lib);
        this.module.broadcast(event);
        ActivityStack activityStack = this.module.getActivityStack();
        activityStack.commit();
        activityStack.flush();
        this.module.setSaveState(0);
        activityStack.sendNotifcations(new ActivityStackEvent(activityStack, 1));
    }

    private Map dealAllElementDecendents(Library library, int actionCode) throws SemanticException {
        HashMap overriddenValues = new HashMap();
        LevelContentIterator contentIter = new LevelContentIterator((Module)library, library, 1);
        while (contentIter.hasNext()) {
            DesignElement tmpElement = (DesignElement)contentIter.next();
            if (!tmpElement.getDefn().canExtend()) continue;
            Map values = this.dealElementDecendents(library, tmpElement, actionCode);
            if (actionCode != 1) continue;
            overriddenValues.putAll(values);
        }
        return overriddenValues;
    }

    private void doAddLibrary(String libraryFileName, String namespace, int action, Map overriddenValues) throws SemanticException, DesignFileException {
        URL url = this.module.findResource(libraryFileName, 2);
        if (action == 1 && url == null) {
            if (this.module.findIncludedLibrary(namespace) == null) {
                this.addLibraryStructure(libraryFileName, namespace);
            }
            return;
        }
        Library library = this.module.loadLibrary(libraryFileName, namespace);
        library.setReadOnly();
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startTrans();
        LibraryRecord record = null;
        if (action == 2) {
            record = new LibraryRecord(this.module, library, true);
        }
        if (action == 1) {
            record = new LibraryRecord(this.module, library, overriddenValues);
        }
        this.getActivityStack().execute(record);
        if (this.module.findIncludedLibrary(namespace) == null) {
            this.addLibraryStructure(libraryFileName, namespace);
        }
        activityStack.commit();
    }

    private void addLibraryStructure(String libraryFileName, String namespace) throws SemanticException {
        IncludedLibrary includeLibrary = StructureFactory.createIncludeLibrary();
        includeLibrary.setFileName(libraryFileName);
        includeLibrary.setNamespace(namespace);
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.module);
        propCommand.addItem((MemberRef)new CachedMemberRef(propDefn), (Object)includeLibrary);
    }

    private Map unresolveElementDescendent(Module module, DesignElement child) throws SemanticException {
        ElementRefValue value = (ElementRefValue)child.getLocalProperty(module, "extends");
        DesignElement parent = value.getElement();
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (child instanceof ExtendedItem) {
            if (!$assertionsDisabled && !(parent instanceof ExtendedItem)) {
                throw new AssertionError();
            }
            if (!((ExtendedItem)child).hasLocalPropertyValuesOnOwnModel()) {
                ((ExtendedItem)child).getExtensibilityProvider().clearOwnModel();
            }
        }
        if (!child.getDefn().isContainer()) {
            parent.dropDerived(child);
            value.unresolved(value.getName());
            return Collections.EMPTY_MAP;
        }
        Map overriddenValues = ElementStructureUtil.collectPropertyValues(module, child);
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startSilentTrans();
        LevelContentIterator contentIter = new LevelContentIterator(module, child, 1);
        while (contentIter.hasNext()) {
            DesignElement tmpElement = (DesignElement)contentIter.next();
            ContentCommand command = new ContentCommand(module, tmpElement.getContainerInfo());
            command.remove(tmpElement, false, true);
        }
        activityStack.commit();
        parent.dropDerived(child);
        value.unresolved(value.getName());
        return overriddenValues;
    }

    private void getAllDescdents(DesignElement tmpElement, List results) {
        List descends = tmpElement.getDerived();
        results.addAll(descends);
        int i = 0;
        while (i < descends.size()) {
            this.getAllDescdents((DesignElement)descends.get(i), results);
            ++i;
        }
    }

    private void removeIncludeLibrary(String fileName, String namespace) throws PropertyValueException {
        if (!$assertionsDisabled && fileName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && namespace == null) {
            throw new AssertionError();
        }
        List includeLibraries = this.module.getIncludedLibraries();
        Iterator iter = includeLibraries.iterator();
        while (iter.hasNext()) {
            IncludedLibrary includeLibrary = (IncludedLibrary)iter.next();
            if (!namespace.equals(includeLibrary.getNamespace()) || !fileName.endsWith(StringUtil.extractFileNameWithSuffix(includeLibrary.getFileName()))) continue;
            ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
            ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.module);
            propCommand.removeItem((MemberRef)new CachedMemberRef(propDefn), includeLibrary);
            break;
        }
    }
}

