/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.report.model.util.XMLWriter;

public class DocumentXMLWriter
extends XMLWriter {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.writer.DocumentXMLWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DocumentXMLWriter(File outputFile, String signature) throws IOException {
        super(outputFile, signature);
        this.markLineNumber = false;
    }

    public DocumentXMLWriter(OutputStream os, String signature) throws IOException {
        super(os, signature);
        this.markLineNumber = false;
    }

    public void attribute(String attrName, String value) {
        if (value == null) {
            return;
        }
        this.checkAttribute();
        if (!$assertionsDisabled && !this.elementActive) {
            throw new AssertionError();
        }
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
            } else if (c == '<') {
                this.out.print("&lt;");
            } else if (c == '\"') {
                this.out.print("&quot;");
            } else if (c < ' ') {
                this.out.print("&#x");
                this.out.print(Integer.toHexString(c));
                this.out.print(';');
            } else {
                this.out.print(c);
            }
            ++i;
        }
        this.out.print("\"");
    }

    protected void emitStartTag(String tagName) {
        this.elementStack.push(tagName);
        this.elementActive = true;
        this.out.print("<");
        this.out.print(tagName);
    }

    public void endElement() {
        if (!this.pendingElementStack.isEmpty()) {
            this.pendingElementStack.pop();
            return;
        }
        if (!$assertionsDisabled && this.elementStack.size() <= 0) {
            throw new AssertionError();
        }
        String tagName = (String)this.elementStack.pop();
        if (this.elementActive) {
            this.out.print("/>");
        } else {
            this.out.print("</");
            this.out.print(tagName);
            this.out.print(">");
        }
        this.elementActive = false;
    }

    public void literal(String text) {
        if (!this.markLineNumber) {
            this.out.print(text);
            return;
        }
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            this.out.print(c);
            ++i;
        }
    }

    public void text(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
            } else if (c == '<') {
                this.out.print("&lt;");
            } else {
                this.out.print(c);
            }
            ++i;
        }
    }

    public void textCDATA(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        this.out.print("<![CDATA[");
        this.out.print(text);
        this.out.print("]]>");
    }

    protected void checkAttribute() {
        this.flushPendingElements();
    }

    protected void printLine() {
    }
}

