/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.query.service.impl;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.cmdbfservice.IQueryHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;

public abstract class AbstractQueryHandlerFactory
implements IQueryHandlerFactory {
    private static final int ITEM_TEMPLATE = 0;
    private static final int RELATIONSHIP_TEMPLATE = 1;
    private Map<Integer, Map<Integer, IQueryHandler>> cachedHandlers = new Hashtable<Integer, Map<Integer, IQueryHandler>>();

    public IItemTemplateHandler createItemTemplateHandler() throws CMDBfServiceException {
        return (IItemTemplateHandler)this.createHandler(null, 0);
    }

    public IItemConstraintHandler createItemConstraintHandler(IConstraint constraint) throws CMDBfServiceException {
        return (IItemConstraintHandler)this.createHandler(constraint, 0);
    }

    public IRelationshipTemplateHandler createRelationshipTemplateHandler() throws CMDBfServiceException {
        return (IRelationshipTemplateHandler)this.createHandler(null, 1);
    }

    public IRelationshipConstraintHandler createRelationshipConstraintHandler(IConstraint constraint) throws CMDBfServiceException {
        return (IRelationshipConstraintHandler)this.createHandler(constraint, 1);
    }

    private IQueryHandler createHandler(IConstraint constraint, int templateType) throws CMDBfServiceException {
        Map<Integer, IQueryHandler> nestedMap;
        int constraintType;
        Object handler = null;
        int n = constraintType = constraint == null ? -1 : constraint.getType();
        if (this.isCachingSupported()) {
            nestedMap = this.cachedHandlers.get(templateType);
            IQueryHandler iQueryHandler = handler = nestedMap == null ? null : nestedMap.get(constraintType);
            if (handler != null) {
                return handler;
            }
        }
        switch (constraintType) {
            case 0: {
                handler = templateType == 0 ? this.createItemInstanceHandler() : this.createRelationshipInstanceHandler();
                break;
            }
            case 1: {
                handler = templateType == 0 ? this.createItemRecordHandler() : this.createRelationshipRecordHandler();
                break;
            }
            case 2: {
                handler = templateType == 0 ? this.createItemPropertyHandler() : this.createRelationshipPropertyHandler();
                break;
            }
            case 3: {
                handler = templateType == 0 ? this.createItemXPathHandler() : this.createRelationshipXPathHandler();
                break;
            }
            case -1: {
                handler = templateType == 0 ? this.createItemHandler() : this.createRelationshipHandler();
                break;
            }
            default: {
                throw new CMDBfServiceException(1, 3, CMDBfMessages.faultsQueryUnsupportedConstraint);
            }
        }
        if (handler != null && this.isCachingSupported()) {
            nestedMap = this.cachedHandlers.get(templateType);
            if (nestedMap == null) {
                nestedMap = new Hashtable<Integer, IQueryHandler>();
                this.cachedHandlers.put(templateType, nestedMap);
            }
            nestedMap.put(constraintType, (IQueryHandler)handler);
        }
        return handler;
    }

    protected IItemConstraintHandler createItemInstanceHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("instanceIdConstraint");
    }

    protected IItemConstraintHandler createItemPropertyHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("propertyValue");
    }

    protected IItemConstraintHandler createItemRecordHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("recordConstraint");
    }

    protected IItemConstraintHandler createItemXPathHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("xpathExpression");
    }

    protected IRelationshipConstraintHandler createRelationshipInstanceHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("instanceIdConstraint");
    }

    protected IRelationshipConstraintHandler createRelationshipPropertyHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("propertyValue");
    }

    protected IRelationshipConstraintHandler createRelationshipRecordHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("recordConstraint");
    }

    protected IRelationshipConstraintHandler createRelationshipXPathHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("xpathExpression");
    }

    protected IItemTemplateHandler createItemHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("itemTemplate");
    }

    protected IRelationshipTemplateHandler createRelationshipHandler() throws CMDBfServiceException {
        throw this.unsupportedHandler("relationshipTemplate");
    }

    private CMDBfServiceException unsupportedHandler(String handlerName) {
        return new CMDBfServiceException(1, 3, CMDBfMessages.faultsQueryUnsupportedConstraint, CMDBfInternalUtility.createElement((String)"http://cmdbf.org/schema/1-0-0/datamodel", (String)"cmdbf:constraint", (String[][])new String[][]{{"namespace", "http://cmdbf.org/schema/1-0-0/datamodel"}, {"localName", handlerName}}));
    }

    protected boolean isCachingSupported() {
        return true;
    }
}

