/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.DataExceptionMocker;
import org.eclipse.birt.data.engine.script.NEvaluator;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ExprEvaluateUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ExprEvaluateUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static Object evaluateExpression(IBaseExpression dataExpr, IResultIterator odiResult, Scriptable scope) throws BirtException {
        Object exprValue = null;
        if (dataExpr == null) {
            throw new DataException("data.engine.BadDataExpression");
        }
        Object handle = dataExpr.getHandle();
        if (handle instanceof CompiledExpression) {
            CompiledExpression expr = (CompiledExpression)handle;
            Object value = ExprEvaluateUtil.evaluateCompiledExpression(expr, odiResult, scope);
            try {
                if (value instanceof BirtException) {
                    throw (BirtException)((Object)value);
                }
                exprValue = DataTypeUtil.convert((Object)value, (int)dataExpr.getDataType());
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        } else if (handle instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)handle;
            Object resultExpr = ExprEvaluateUtil.evaluateExpression(ce.getExpression(), odiResult, scope);
            Object resultOp1 = ce.getOperand1() != null ? ExprEvaluateUtil.evaluateExpression(ce.getOperand1(), odiResult, scope) : null;
            Object resultOp2 = ce.getOperand2() != null ? ExprEvaluateUtil.evaluateExpression(ce.getOperand2(), odiResult, scope) : null;
            String op1Text = ce.getOperand1() != null ? ce.getOperand1().getText() : null;
            String op2Text = ce.getOperand2() != null ? ce.getOperand2().getText() : null;
            exprValue = ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), ScriptEvalUtil.newExprInfo(op1Text, resultOp1), ScriptEvalUtil.newExprInfo(op2Text, resultOp2));
        } else {
            DataException e = new DataException("data.engine.InvalidExprHandle");
            throw e;
        }
        if (exprValue instanceof DataExceptionMocker) {
            throw ((DataExceptionMocker)((Object)exprValue)).getCause();
        }
        return exprValue;
    }

    public static Object evaluateCompiledExpression(CompiledExpression expr, IResultObject ro, int currentIndex, Scriptable scope) throws DataException {
        Object object;
        if (expr instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression colref = (ColumnReferenceExpression)expr;
            if (colref.isIndexed()) {
                int idx = colref.getColumnindex();
                if (idx == 0) {
                    return new Integer(currentIndex);
                }
                if (ro != null) {
                    try {
                        return DataTypeUtil.convert((Object)ro.getFieldValue(idx), (int)colref.getDataType());
                    }
                    catch (BirtException e) {
                        throw DataException.wrap(e);
                    }
                }
                return null;
            }
            String name = colref.getColumnName();
            if ("_rowPosition".equals(name)) {
                return new Integer(currentIndex);
            }
            if (ro != null) {
                try {
                    return DataTypeUtil.convert((Object)ro.getFieldValue(name), (int)colref.getDataType());
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
            return null;
        }
        Context cx = Context.enter();
        try {
            object = expr.evaluate(cx, scope);
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public static Object evaluateCompiledExpression(CompiledExpression expr, IResultIterator odiResult, Scriptable scope) throws DataException {
        return ExprEvaluateUtil.evaluateCompiledExpression(expr, odiResult.getCurrentResult(), odiResult.getCurrentResultIndex(), scope);
    }

    public static Object evaluateRawExpression(IBaseExpression dataExpr, Scriptable scope) throws BirtException {
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, false);
    }

    public static Object evaluateRawExpression2(IBaseExpression dataExpr, Scriptable scope) throws BirtException {
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, true);
    }

    private static Object doEvaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, boolean javaType) throws BirtException {
        block10: {
            block11: {
                Context cx;
                block9: {
                    Object object;
                    if (dataExpr == null) {
                        return null;
                    }
                    try {
                        cx = Context.enter();
                        if (!(dataExpr instanceof IScriptExpression)) break block9;
                        if (((IScriptExpression)dataExpr).getText() == null) {
                            throw new DataException("data.engine.EmptyExpression");
                        }
                        Object value = JavascriptEvalUtil.evaluateRawScript((Context)cx, (Scriptable)scope, (String)((IScriptExpression)dataExpr).getText(), (String)"source", (int)0);
                        if (javaType) {
                            value = JavascriptEvalUtil.convertJavascriptValue((Object)value);
                        }
                        object = value = DataTypeUtil.convert((Object)value, (int)dataExpr.getDataType());
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        Context.exit();
                        throw throwable;
                    }
                    Context.exit();
                    return object;
                }
                if (!(dataExpr instanceof IConditionalExpression)) break block10;
                if (dataExpr.getHandle() == null) break block11;
                Boolean bl = new Boolean(((NEvaluator)dataExpr.getHandle()).evaluate(cx, scope));
                Object var8_10 = null;
                Context.exit();
                return bl;
            }
            IScriptExpression opr = ((IConditionalExpression)dataExpr).getExpression();
            int oper = ((IConditionalExpression)dataExpr).getOperator();
            IScriptExpression operand1 = ((IConditionalExpression)dataExpr).getOperand1();
            IScriptExpression operand2 = ((IConditionalExpression)dataExpr).getOperand2();
            Object object = ScriptEvalUtil.evalConditionalExpr(ExprEvaluateUtil.doEvaluateRawExpression(opr, scope, javaType), oper, ExprEvaluateUtil.doEvaluateRawExpression(operand1, scope, javaType), ExprEvaluateUtil.doEvaluateRawExpression(operand2, scope, javaType));
            Object var8_11 = null;
            Context.exit();
            return object;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        Object var8_12 = null;
        Context.exit();
        return null;
    }

    public static Object evaluateValue(IBaseExpression dataExpr, int index, IResultObject roObject, Scriptable scope) throws BirtException {
        Object handle;
        Object exprValue = null;
        Object object = handle = dataExpr == null ? null : dataExpr.getHandle();
        if (handle instanceof CompiledExpression) {
            CompiledExpression expr = (CompiledExpression)handle;
            Object value = ExprEvaluateUtil.evaluateCompiledExpression(expr, index, roObject, scope);
            try {
                exprValue = DataTypeUtil.convert((Object)value, (int)dataExpr.getDataType());
            }
            catch (BirtException birtException) {
                throw new DataException("data.engine.InconvertibleDatatype", new Object[]{value, value.getClass(), DataType.getClass((int)dataExpr.getDataType())});
            }
        } else if (dataExpr instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)dataExpr;
            Object resultExpr = ExprEvaluateUtil.evaluateValue(ce.getExpression(), index, roObject, scope);
            Object resultOp1 = ce.getOperand1() != null ? ExprEvaluateUtil.evaluateValue(ce.getOperand1(), index, roObject, scope) : null;
            Object resultOp2 = ce.getOperand2() != null ? ExprEvaluateUtil.evaluateValue(ce.getOperand2(), index, roObject, scope) : null;
            String op1Text = ce.getOperand1() != null ? ce.getOperand1().getText() : null;
            String op2Text = ce.getOperand2() != null ? ce.getOperand2().getText() : null;
            exprValue = ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), ScriptEvalUtil.newExprInfo(op1Text, resultOp1), ScriptEvalUtil.newExprInfo(op2Text, resultOp2));
        } else {
            DataException e = new DataException("data.engine.InvalidExprHandle");
            throw e;
        }
        if (exprValue instanceof DataExceptionMocker) {
            throw ((DataExceptionMocker)((Object)exprValue)).getCause();
        }
        return exprValue;
    }

    private static Object evaluateCompiledExpression(CompiledExpression expr, int index, IResultObject roObject, Scriptable scope) throws DataException {
        Object object;
        if (expr instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression colref = (ColumnReferenceExpression)expr;
            if (colref.isIndexed()) {
                int idx = colref.getColumnindex();
                if (idx == 0) {
                    return new Integer(index);
                }
                if (roObject != null) {
                    return roObject.getFieldValue(idx);
                }
                return null;
            }
            String name = colref.getColumnName();
            if ("_rowPosition".equals(name)) {
                return new Integer(index);
            }
            if (roObject != null) {
                return roObject.getFieldValue(name);
            }
            return null;
        }
        Context cx = Context.enter();
        try {
            object = expr.evaluate(cx, scope);
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }
}

