/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetResultSet
implements IDataSetPopulator {
    private int rowIndex;
    private int rowCount;
    private InputStream inputStream;
    private BufferedInputStream bis;
    private DataInputStream dis;
    private IResultClass rsMetaData;
    private int colCount;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DataSetResultSet(InputStream inputStream, IResultClass rsMetaData) {
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMetaData == null) {
            throw new AssertionError();
        }
        this.inputStream = inputStream;
        this.rsMetaData = rsMetaData;
        this.colCount = rsMetaData.getFieldCount();
    }

    public IResultObject next() throws DataException {
        this.initLoad();
        if (this.rowIndex == this.rowCount) {
            return null;
        }
        try {
            ++this.rowIndex;
            return ResultSetUtil.readResultObject(this.dis, this.rsMetaData, this.colCount);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private void initLoad() throws DataException {
        if (this.dis == null) {
            this.bis = new BufferedInputStream(this.inputStream);
            try {
                this.dis = new DataInputStream(this.bis);
                this.rowCount = IOUtil.readInt((InputStream)this.dis);
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "result data");
            }
        }
    }

    public IResultClass getResultClass() {
        return this.rsMetaData;
    }

    public void close() {
        try {
            if (this.dis != null) {
                this.dis.close();
                this.bis.close();
            }
        }
        catch (IOException iOException) {}
    }
}

