/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;

public class ParameterHint {
    private String m_name;
    private int m_position;
    private Class m_dataType;
    private int m_nativeDataType = 0;
    private boolean m_isInputOptional;
    private String m_defaultInputValue;
    private boolean m_isInputMode;
    private boolean m_isOutputMode;
    private boolean m_isNullable;
    private static final int UNKNOWN_NATIVE_TYPE = 0;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.ParameterHint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz.getName();
        sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    public ParameterHint(String parameterName, boolean isInputMode, boolean isOutputMode) {
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "ParameterHint", new Object[]{parameterName, new Boolean(isInputMode), new Boolean(isOutputMode)});
        }
        if (parameterName == null || parameterName.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ParameterNameCannotBeEmptyOrNull");
            sm_logger.logp(Level.SEVERE, sm_className, "ParameterHint", "The given parameter is null or empty.");
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_name = parameterName;
        this.m_isInputMode = isInputMode;
        this.m_isOutputMode = isOutputMode;
        this.m_isInputOptional = true;
        this.m_isNullable = true;
        sm_logger.exiting(sm_className, "ParameterHint", this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setPosition(int position) {
        if (position < 1) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ParameterPositionIsOneBased");
            sm_logger.logp(Level.SEVERE, sm_className, "setPosition", "Invalid parameter position {0} ", new Integer(position));
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setDataType(Class dataType) {
        boolean isValid;
        block61: {
            block62: {
                block60: {
                    block59: {
                        isValid = false;
                        if (dataType == null) break block59;
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz) break block59;
                        Class<?> clazz2 = class$2;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$2 = Class.forName("java.lang.Double");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz2) break block59;
                        Class<?> clazz3 = class$3;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$3 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz3) break block59;
                        Class<?> clazz4 = class$4;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$4 = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz4) break block59;
                        Class<?> clazz5 = class$5;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$5 = Class.forName("java.util.Date");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz5) break block59;
                        Class<?> clazz6 = class$6;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$6 = Class.forName("java.sql.Date");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz6) break block59;
                        Class<?> clazz7 = class$7;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$7 = Class.forName("java.sql.Time");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz7) break block59;
                        Class<?> clazz8 = class$8;
                        if (clazz8 == null) {
                            try {
                                clazz8 = class$8 = Class.forName("java.sql.Timestamp");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz8) break block59;
                        Class<?> clazz9 = class$9;
                        if (clazz9 == null) {
                            try {
                                clazz9 = class$9 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz9) break block59;
                        Class<?> clazz10 = class$10;
                        if (clazz10 == null) {
                            try {
                                clazz10 = class$10 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType == clazz10) break block59;
                        Class<?> clazz11 = class$11;
                        if (clazz11 == null) {
                            try {
                                clazz11 = class$11 = Class.forName("java.lang.Boolean");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType != clazz11) break block60;
                    }
                    isValid = true;
                }
                if (!isValid || !this.isInputMode() || dataType == null) break block61;
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (dataType == clazz) break block62;
                Class<?> clazz12 = class$10;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$10 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (dataType != clazz12) break block61;
            }
            isValid = false;
        }
        if (!isValid) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.UnsupportedParameterValueType", new Object[]{dataType});
            sm_logger.logp(Level.SEVERE, sm_className, "setDataType", "Invalid parameter data type {0}.", dataType);
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_dataType = dataType;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public void setNativeDataType(int typeCode) {
        this.m_nativeDataType = typeCode;
    }

    public int getNativeDataType() {
        return this.m_nativeDataType;
    }

    public void setIsInputOptional(boolean isInputOptional) {
        if (this.m_isInputMode) {
            this.m_isInputOptional = isInputOptional;
        }
    }

    public boolean isInputOptional() {
        return this.m_isInputMode ? this.m_isInputOptional : true;
    }

    public void setIsNullable(boolean isNullable) {
        this.m_isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.m_isNullable;
    }

    public void setDefaultInputValue(String defaultInputValue) {
        if (this.m_isInputMode) {
            this.m_defaultInputValue = defaultInputValue;
        }
    }

    public String getDefaultInputValue() {
        return this.m_isInputMode ? this.m_defaultInputValue : null;
    }

    public boolean isInputMode() {
        return this.m_isInputMode;
    }

    public boolean isOutputMode() {
        return this.m_isOutputMode;
    }

    void updateHint(ParameterHint hint) {
        String methodName = "updateHint";
        sm_logger.entering(sm_className, methodName, hint);
        this.m_name = hint.m_name;
        if (hint.m_position != 0) {
            this.m_position = hint.m_position;
        }
        if (hint.m_dataType != null) {
            this.m_dataType = hint.m_dataType;
        }
        if (hint.m_nativeDataType != 0) {
            this.m_nativeDataType = hint.m_nativeDataType;
        }
        this.m_isInputOptional = hint.m_isInputOptional;
        this.m_defaultInputValue = hint.m_defaultInputValue;
        this.m_isInputMode = hint.m_isInputMode;
        this.m_isOutputMode = hint.m_isOutputMode;
        this.m_isNullable = hint.m_isNullable;
        sm_logger.exiting(sm_className, methodName, this);
    }

    public Class getEffectiveDataType(String odaDataSourceId, String dataSetType) {
        return DataTypeUtil.toTypeClass(this.getEffectiveOdaType(odaDataSourceId, dataSetType));
    }

    int getEffectiveOdaType(String odaDataSourceId, String dataSetType) {
        int odaType;
        if (this.getNativeDataType() != 0 && (odaType = DataTypeUtil.toOdaType(this.getNativeDataType(), odaDataSourceId, dataSetType)) != 0) {
            return odaType;
        }
        Class typeInHint = this.getDataType();
        return DataTypeUtil.toOdaType(typeInHint);
    }
}

