/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.script;

import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.RowDataMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSLevelObject
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private DimensionCursor cursor;
    private String levelName;
    private String defaultColumnName;

    JSLevelObject(DimensionCursor cursor, String levelName) throws OLAPException {
        this.cursor = cursor;
        this.levelName = levelName;
        RowDataMetaData meta = this.cursor.getMetaData();
        String defaultName = OlapExpressionUtil.getDisplayColumnName(this.levelName);
        int i = 0;
        while (i < meta.getColumnCount()) {
            if (meta.getColumnName(i).equals(defaultName)) {
                this.defaultColumnName = defaultName;
                break;
            }
            ++i;
        }
        if (this.defaultColumnName == null) {
            this.defaultColumnName = this.levelName;
        }
    }

    public String getClassName() {
        return "JSLevelObject";
    }

    public Object getDefaultValue(Class hint) {
        return this.getKeyValue();
    }

    private Object getKeyValue() {
        try {
            return this.cursor.getObject(this.defaultColumnName);
        }
        catch (OLAPException oLAPException) {
            return null;
        }
    }

    public Object get(String name, Scriptable start) {
        try {
            return this.cursor.getObject(OlapExpressionUtil.getAttributeColumnName(this.levelName, name));
        }
        catch (OLAPException e) {
            throw new RuntimeException((Throwable)((Object)new DataException(e.getLocalizedMessage())));
        }
    }
}

