/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.script;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionHandler;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;

public class OLAPExpressionCompiler {
    public static void compile(Context cx, IBaseExpression expr) {
        if (expr instanceof IConditionalExpression) {
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getExpression());
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getOperand1());
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getOperand2());
        } else if (expr instanceof IScriptExpression) {
            OLAPExpressionCompiler.prepareScriptExpression(cx, (IScriptExpression)expr);
        }
    }

    private static void prepareScriptExpression(Context cx, IScriptExpression expr1) {
        if (expr1 == null) {
            return;
        }
        String exprText = expr1.getText();
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(cx);
        Parser p = new Parser(compilerEnv, cx.getErrorReporter());
        ScriptOrFnNode tree = p.parse(exprText, null, 0);
        Interpreter compiler = new Interpreter();
        Object compiledOb = compiler.compile(compilerEnv, tree, null, false);
        Script script = compiler.createScriptObject(compiledOb, null);
        expr1.setHandle(new OLAPExpressionHandler(script));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compile(IBaseExpression expression) {
        try {
            Context cx = Context.enter();
            OLAPExpressionCompiler.compile(cx, expression);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        Context.exit();
    }
}

