/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.demo.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DemoConfig {
    private String tomcatDir;
    private String port;
    private String hostname;
    private String demoDir;
    private String domainURI;
    private String brokerURI;

    public void start() {
        this.getInputs();
        String serverURI = "http://" + this.hostname + ":" + this.port;
        this.domainURI = String.valueOf(serverURI) + "/cosmos/services/domain";
        this.brokerURI = String.valueOf(serverURI) + "/cosmos/services/broker";
        boolean rc = this.setDomainEPR(String.valueOf(this.tomcatDir) + "/webapps/cosmos/WEB-INF/classes/domainEPR.xml");
        if (rc) {
            System.out.println("Set management domain EPR for broker successfully.");
        } else {
            System.out.println("Failed to set management domain EPR for broker.");
        }
        rc = this.setDomainEPR(String.valueOf(this.tomcatDir) + "/webapps/examplemdr/WEB-INF/classes/domainEPR.xml");
        if (rc) {
            System.out.println("Set management domain EPR for Example MDR successfully.");
        } else {
            System.out.println("Failed to set management domain EPR for Example MDR.");
        }
        rc = this.setDomainEPR(String.valueOf(this.tomcatDir) + "/webapps/smlmdr/WEB-INF/classes/domainEPR.xml");
        if (rc) {
            System.out.println("Set management domain EPR for SML MDR successfully.");
        } else {
            System.out.println("Failed to set management domain EPR for SML MDR.");
        }
        rc = this.setDomainEPR(String.valueOf(this.tomcatDir) + "/webapps/logging/WEB-INF/classes/domainEPR.xml");
        if (rc) {
            System.out.println("Set management domain EPR for logging data manager successfully.");
        } else {
            System.out.println("Failed to set management domain EPR for logging data manager.");
        }
        rc = this.setCBEDataDir();
        if (rc) {
            System.out.println("Set CBEData.dir for logging data manager successfully.");
        } else {
            System.out.println("Failed to set CBEData.dir for logging data manager.");
        }
        rc = this.setDomainEPR(String.valueOf(this.tomcatDir) + "/webapps/stat/WEB-INF/classes/domainEPR.xml");
        if (rc) {
            System.out.println("Set management domain EPR for stat data manager successfully.");
        } else {
            System.out.println("Failed to set management domain EPR for stat data manager.");
        }
        rc = this.setDerbyHome();
        if (rc) {
            System.out.println("Set derby.system.home for statistical data manager successfully.");
        } else {
            System.out.println("Failed to set derby.system.home for statistical data manager.");
        }
        if (!this.changeSMLConfigFile()) {
            System.out.println("Failed to update SML MDR config file.");
        } else {
            System.out.println("Updated SML MDR config file successfully.");
        }
    }

    public String getCommandLineInput(String question, String[] acceptedValues) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = null;
        try {
            boolean matched = false;
            block2: while (!matched) {
                System.out.print(question);
                input = br.readLine();
                if (acceptedValues != null && input != null) {
                    String[] stringArray = acceptedValues;
                    int n = acceptedValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String acceptedValue = stringArray[n2];
                        if (acceptedValue.equals(input.trim())) {
                            matched = true;
                            continue block2;
                        }
                        ++n2;
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            System.exit(1);
        }
        return input;
    }

    public void getInputs() {
        System.out.println("This program will configure some environment variables for the COSMOS demo to run. \nWe assume that the Tomcat server and the directory where you unzipped the demo program are on the same computer.");
        do {
            this.tomcatDir = this.getCommandLineInput("Apache Tomcat install directory: ", null);
        } while (!this.validateTomcatDir());
        this.hostname = this.getCommandLineInput("Hostname of the Tomcat server (e.g. www.eclipse.org): ", null);
        this.port = this.getCommandLineInput("Tomcat port number: ", null);
        do {
            this.demoDir = this.getCommandLineInput("COSMOS Demo install directory: ", null);
        } while (!this.validateDemoDir());
    }

    private boolean validateTomcatDir() {
        File webapps;
        if (this.tomcatDir == null) {
            return false;
        }
        File tomcat = new File(this.tomcatDir);
        if (tomcat.exists() && tomcat.isDirectory() && (webapps = new File(String.valueOf(this.tomcatDir) + "/webapps")).exists() && webapps.isDirectory()) {
            return true;
        }
        System.out.println("Invalid Tomcat directory");
        return false;
    }

    private boolean validateDemoDir() {
        File demoLoc = new File(this.demoDir);
        if (demoLoc.exists() && demoLoc.isDirectory() && demoLoc.getName().equals("cosmos-demo")) {
            return true;
        }
        System.out.println("Invalid COSMOS demo install directory");
        return false;
    }

    public boolean setDerbyHome() {
        File original = new File(String.valueOf(this.tomcatDir) + "/conf/catalina.properties");
        File temp = new File(String.valueOf(this.tomcatDir) + "/conf/catalina.properties.temp");
        BufferedReader in = null;
        BufferedWriter out = null;
        boolean derbyPropertyPresent = false;
        try {
            try {
                in = new BufferedReader(new FileReader(original));
                out = new BufferedWriter(new FileWriter(temp));
                String line = null;
                String path = String.valueOf(this.demoDir) + "/database";
                path = path.replace('\\', '/');
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("derby.system.home")) {
                        out.write("derby.system.home=" + path);
                        derbyPropertyPresent = true;
                    } else {
                        out.write(line);
                    }
                    out.newLine();
                }
                if (!derbyPropertyPresent) {
                    out.write("derby.system.home=" + path);
                    out.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        original.delete();
        temp.renameTo(original);
        return true;
    }

    public boolean setCBEDataDir() {
        File original = new File(String.valueOf(this.tomcatDir) + "/webapps/logging/WEB-INF/classes/config.properties");
        File temp = new File(String.valueOf(this.tomcatDir) + "/webapps/logging/WEB-INF/classes/config.properties.backup");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            try {
                in = new BufferedReader(new FileReader(original));
                out = new BufferedWriter(new FileWriter(temp));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("CBEData.dir")) {
                        String path = String.valueOf(this.tomcatDir) + "/webapps/logging/WEB-INF/classes/logs";
                        path = path.replace('\\', '/');
                        out.write("CBEData.dir=" + path);
                    } else {
                        out.write(line);
                    }
                    out.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        original.delete();
        temp.renameTo(original);
        return true;
    }

    public boolean setDomainEPR(String eprFilePath) {
        File eprFile = new File(eprFilePath);
        if (!eprFile.exists()) {
            return false;
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(eprFile);
            NodeList nodeList = doc.getDocumentElement().getElementsByTagName("wsa:Address");
            if (nodeList.getLength() > 0) {
                Element addrNode = (Element)nodeList.item(0);
                addrNode.setTextContent(this.domainURI);
            }
            FileOutputStream os = new FileOutputStream(eprFilePath);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(doc.getDocumentElement()), new StreamResult(os));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean changeSMLConfigFile() {
        File original = new File(String.valueOf(this.tomcatDir) + "/webapps/smlmdr/WEB-INF/classes/config.properties");
        File temp = new File(String.valueOf(this.tomcatDir) + "/webapps/smlmdr/WEB-INF/classes/config.properties.temp");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            try {
                in = new BufferedReader(new FileReader(original));
                out = new BufferedWriter(new FileWriter(temp));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("root.directory")) {
                        String path = String.valueOf(this.tomcatDir) + "/webapps/smlmdr/sml-repository";
                        path = path.replace('\\', '/');
                        out.write("root.directory=" + path);
                    } else {
                        out.write(line);
                    }
                    out.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        original.delete();
        temp.renameTo(original);
        return true;
    }

    public static void main(String[] args) {
        new DemoConfig().start();
    }
}

