/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.awt.Toolkit;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class WordUtil {
    public static final double INCH_PX = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final double INCH_PT = 72.0;
    public static final double PT_TWIPS = 20.0;
    public static final double INCH_TWIPS = 1440.0;
    public static final double PX_TWIPS = 1440.0 / INCH_PX;
    public static final double PX_PT = 72.0 / INCH_PX;

    public static String validBookmarkName(String name) {
        String bookmark = name.replaceAll(" ", "_");
        bookmark = bookmark.replaceAll("\"", "_");
        return bookmark;
    }

    public static int convertTo(DimensionType value, int prefValue) {
        if (value == null) {
            return 0;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return (int)((double)prefValue * value.getMeasure() / 100.0);
        }
        return (int)WordUtil.convertTo(value);
    }

    public static double convertTo(DimensionType value) {
        if (value == null || "%".equalsIgnoreCase(value.getUnits())) {
            return -1.0;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * PX_TWIPS;
        }
        double val = value.convertTo("in");
        return val * 1440.0;
    }

    public static int getWidth(int cw, IStyle style) {
        float left = WordUtil.getPadding(style.getPaddingLeft());
        float right = WordUtil.getPadding(style.getPaddingRight());
        if (left > (float)cw) {
            left = 0.0f;
        }
        if (right > (float)cw) {
            right = 0.0f;
        }
        if (left + right > (float)cw) {
            right = 0.0f;
        }
        return (int)((float)cw - left - right);
    }

    public static float getPadding(String padding) {
        float value = 0.0f;
        try {
            value = Float.parseFloat(padding) / 50.0f;
        }
        catch (Exception exception) {}
        return value;
    }

    public static double convertImageSize(DimensionType value, int ref) {
        if (value == null) {
            return (double)ref * PX_PT;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * PX_PT;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() / 100.0 * (double)ref * PX_PT;
        }
        return value.convertTo("in") * 72.0;
    }

    public static double twipToPt(double t) {
        return t / 20.0;
    }
}

