/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.common;

import org.eclipse.cosmos.dc.cmdbf.services.cmdbfservice.AbstractServiceHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.IItemNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.common.IRelationshipNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IRegistrationServiceOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

public abstract class AbstractNotificationOperation
extends AbstractServiceHandler {
    private INotificationHandlerFactory factory;
    private IRegistrationServiceOutputArtifactFactory outputArtifactFactory;

    public AbstractNotificationOperation(INotificationHandlerFactory factory, IRegistrationServiceOutputArtifactFactory outputArtifactFactory) {
        this.factory = factory;
        this.outputArtifactFactory = outputArtifactFactory;
    }

    protected INotificationHandlerFactory getFactory() {
        return this.factory;
    }

    protected void execute(IRequest request, IResponse response, int type) throws CMDBfServiceException {
        this.handleGraphElementCollection((IGraphElementCollection)request.getItemList(), response, type, true);
        this.handleGraphElementCollection((IGraphElementCollection)request.getRelationshipList(), response, type, false);
    }

    private void handleGraphElementCollection(IGraphElementCollection collection, IResponse response, int type, boolean item) throws CMDBfServiceException {
        INotificationHandler serviceHandler;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        IItemNotificationHandler itemHandler = null;
        IRelationshipNotificationHandler relationshipHandler = null;
        if (item) {
            itemHandler = this.getFactory().createItemHandler(type);
        } else {
            relationshipHandler = this.getFactory().createRelationshipHandler(type);
        }
        INotificationHandler iNotificationHandler = serviceHandler = itemHandler == null ? relationshipHandler : itemHandler;
        if (!serviceHandler.isInitialized()) {
            serviceHandler.initialize(this.getInit());
        }
        IGraphElement[] elements = collection.getElements();
        int i = 0;
        while (i < elements.length) {
            response.addInstanceResponse(itemHandler == null ? relationshipHandler.handle(type, (IRelationship)elements[i]) : itemHandler.handle(type, (IItem)elements[i]));
            ++i;
        }
    }

    protected IRegistrationServiceOutputArtifactFactory getOutputArtifactFactory() {
        if (this.outputArtifactFactory == null) {
            this.outputArtifactFactory = this.createArtifactFactory();
        }
        return this.outputArtifactFactory;
    }

    protected abstract IRegistrationServiceOutputArtifactFactory createArtifactFactory();
}

